/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import processing.core.PApplet;
import processing.core.PImage;

public class frogsport
extends PApplet {
    int KEY_LEFT = 0;
    int KEY_RIGHT = 1;
    int KEY_UP = 2;
    int KEY_DOWN = 3;
    int KEY_RET = 4;
    int KEY_BACKSPACE = 5;
    int KEY_SPACE = 6;
    int KEY_Z = 7;
    int KEY_R = 8;
    int KEY_MAX = 9;
    int GAME_INTRO = 0;
    int GAME_PLAY = 1;
    int GAME_BETWEEN = 3;
    int GAME_END = 2;
    int time;
    int gameState = this.GAME_INTRO;
    int stageMenu = -1;
    boolean[] keysDown;
    CapsFont words;
    int worldScale = 2;
    Dude duder;
    Level lev;
    ArrayList images = new ArrayList();
    float s_offx = 80.0f;
    float s_offy = 70.0f;
    int s_tile_size_y = 16;
    int s_tile_size_x = 12;
    int s_s = 2;
    String[] levels = new String[]{"lev0.txt", "lev1.txt", "lev4.txt", "lev6.txt", "lev3.txt", "lev5.txt", "lev9.txt", "lev7.txt", "lev2.txt", "lev8.txt"};
    String[] levelNames = new String[]{"frogs walk right", "frogs cant jump", "frogs make room", "frogs cant multitask", "above and below", "a shallow pit", "race to the top", "frogs cant swim", "love trumps all", "teamwork"};
    boolean[] completed;
    int curLevel = 0;
    PImage realfrog;
    boolean slowMode = false;
    boolean retPressedLast = false;
    boolean spacePressedLast = false;
    boolean zPressedLast = false;
    boolean arrowsPressedLast = false;
    boolean readyToAdvance = false;
    boolean failedPress = false;
    boolean g_pswap = false;
    int FSTATE_MOVE = 0;
    int FSTATE_TALK = 1;
    int FSTATE_IDLE = 2;
    int BOY = 0;
    int GIRL = 1;
    int STATE_DROWNED = -2;
    int STATE_DEAD = -1;
    int STATE_IDLE = 1;
    int STATE_WALK = 2;
    int STATE_PREP = 3;
    int STATE_CENS = 4;
    int STATE_BABY = 5;
    int STATE_EMERGE = 6;
    int CENSOR_TIME = 20;
    FrogData fdata;
    int TILE_NONE = 0;
    int TILE_WALL = 2;
    int TILE_CIEL = 1;
    int TILE_GOAL = -1;
    int TILE_FROG = 3;
    int frogW = 17;
    int frogH = 32;

    public boolean rectOverlap(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return !(f3 < f5 || f > f7 || f4 < f6 || f2 > f8);
    }

    public void display(PImage pImage, int n, int n2, int n3, boolean bl) {
        int n4 = 1;
        if (bl) {
            this.pushMatrix();
            this.scale(-1.0f, 1.0f);
            n4 = -1;
        }
        this.image(pImage, n4 * n, n2, n4 * pImage.width * n3, pImage.height * n3);
        if (bl) {
            this.popMatrix();
        }
    }

    public PImage managedRequestImage(String string) {
        PImage pImage = this.requestImage(string);
        this.images.add(pImage);
        return pImage;
    }

    public int requestsSatisfied() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.images.size()) {
            PImage pImage = (PImage)this.images.get(n2);
            if (pImage.width != 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void setup() {
        this.size(800, 600);
        this.frameRate(50.0f);
        this.noSmooth();
        this.keysDown = new boolean[this.KEY_MAX];
        int n = 0;
        while (n < this.KEY_MAX) {
            this.keysDown[n] = false;
            ++n;
        }
        this.words = new CapsFont("alphabet.gif");
        this.fdata = new FrogData();
        this.completed = new boolean[this.levels.length];
        n = 0;
        while (n < this.completed.length) {
            this.completed[n] = false;
            ++n;
        }
        this.realfrog = this.managedRequestImage("frogreal.gif");
    }

    public void draw() {
        int n = this.requestsSatisfied();
        if (n < this.images.size()) {
            this.background(0.0f, 128.0f, 0.0f);
            this.fill(200.0f, 10.0f, 10.0f);
            this.stroke(100.0f, 30.0f, 30.0f);
            this.rect(50.0f, 200.0f, 425 * n / this.images.size(), 20.0f);
            return;
        }
        if (this.gameState == this.GAME_INTRO) {
            ++this.time;
            this.background(200.0f, 200.0f, 0.0f);
            this.fill(50.0f, 100.0f, 50.0f);
            if (this.stageMenu == -1) {
                this.words.DrawString(30.0f, 20.0f, "endless frog kids", 7);
                this.words.DrawString(150.0f, 110.0f, "press z to start", 5);
                int n2 = 0;
                while (n2 < 20) {
                    int n3 = 0;
                    while (n3 < 7) {
                        this.fdata.idle[(n2 + n3) % 2].display(-2 + 40 * n2, 150 + 70 * n3, this.time, true, 4, true);
                        ++n3;
                    }
                    ++n2;
                }
            } else {
                this.background(100.0f, 150.0f, 50.0f);
                this.fill(50.0f, 100.0f, 150.0f);
                this.stroke(100.0f, 30.0f, 30.0f);
                this.words.DrawString(20.0f, 20.0f, "select level", 10);
                int n4 = 0;
                while (n4 < this.levels.length) {
                    if (n4 == this.curLevel) {
                        this.fdata.walk[1].display(20.0f, 100 + n4 * 7 * 6, this.time, true, 2, true);
                        this.fill(50.0f, 100.0f, 150.0f);
                        this.stroke(100.0f, 30.0f, 30.0f);
                        this.rect(50.0f, 100 + n4 * 7 * 6, this.levelNames[n4].length() * 5 * 6, 36.0f);
                        if (this.completed[n4]) {
                            this.words.DrawString(55 + this.levelNames[n4].length() * 5 * 6, 100 + n4 * 7 * 6 + 15, "completed", 2);
                        }
                    } else if (this.completed[n4]) {
                        this.fill(150.0f, 150.0f, 150.0f);
                        this.stroke(100.0f, 100.0f, 100.0f);
                        this.rect(50.0f, 100 + n4 * 7 * 6, this.levelNames[n4].length() * 5 * 6, 36.0f);
                    }
                    this.words.DrawString(53.0f, 100 + n4 * 7 * 6 + 3, this.levelNames[n4], 5);
                    ++n4;
                }
                if ((this.keysDown[this.KEY_RIGHT] || this.keysDown[this.KEY_DOWN]) && !this.arrowsPressedLast) {
                    this.curLevel = (this.curLevel + 1) % this.levels.length;
                }
                if ((this.keysDown[this.KEY_LEFT] || this.keysDown[this.KEY_UP]) && !this.arrowsPressedLast) {
                    this.curLevel = (this.curLevel + this.levels.length - 1) % this.levels.length;
                }
                boolean bl = this.arrowsPressedLast = this.keysDown[this.KEY_LEFT] || this.keysDown[this.KEY_RIGHT] || this.keysDown[this.KEY_UP] || this.keysDown[this.KEY_DOWN];
            }
            if (this.keysDown[this.KEY_Z] && !this.zPressedLast) {
                if (this.stageMenu == -1) {
                    this.stageMenu = 0;
                }
            } else if (this.readyToAdvance && !this.keysDown[this.KEY_Z] && this.zPressedLast) {
                this.lev = new Level(this.levels[this.curLevel], this.s_offx, this.s_offy, this.s_tile_size_x, this.s_tile_size_y, this.s_s, this.time);
                this.gameState = this.GAME_PLAY;
                this.readyToAdvance = false;
            }
            if (this.stageMenu > -1 && !this.keysDown[this.KEY_Z] && !this.zPressedLast) {
                this.readyToAdvance = true;
            }
            this.zPressedLast = this.keysDown[this.KEY_Z];
            return;
        }
        if (this.gameState == this.GAME_PLAY) {
            this.background(200.0f, 200.0f, 200.0f);
            this.fill(50.0f, 100.0f, 50.0f);
            if (this.keysDown[this.KEY_BACKSPACE]) {
                this.gameState = this.GAME_BETWEEN;
            }
            this.words.DrawString(this.width / 2 - this.levelNames[this.curLevel].length() * 6 * 5 / 2, 20.0f, this.levelNames[this.curLevel], 5);
            this.words.DrawString(220.0f, this.s_offy + (float)(this.s_tile_size_y * this.s_s * this.lev.h) + 100.0f + 20.0f, "to play press z and arrows", this.worldScale);
            this.words.DrawString(250.0f, this.s_offy + (float)(this.s_tile_size_y * this.s_s * this.lev.h) + 100.0f + 35.0f, "press r to reset level", this.worldScale);
            this.words.DrawString(180.0f, this.s_offy + (float)(this.s_tile_size_y * this.s_s * this.lev.h) + 100.0f + 50.0f, "press q to return to level select", this.worldScale);
            this.words.DrawString(200.0f, this.s_offy + (float)(this.s_tile_size_y * this.s_s * this.lev.h) + 45.0f, "now producing", 4);
            this.fdata.idle[this.lev.activeGender].display(535.0f, this.s_offy + (float)(this.s_tile_size_y * this.s_s * this.lev.h) + 20.0f, this.time, true, 4, true);
            if (this.keysDown[this.KEY_R]) {
                this.lev = new Level(this.levels[this.curLevel], this.s_offx, this.s_offy, this.s_tile_size_x, this.s_tile_size_y, this.s_s, this.time);
            }
            if (!this.slowMode || this.keysDown[this.KEY_RET] && !this.retPressedLast || this.keysDown[this.KEY_BACKSPACE]) {
                this.lev.Update(this.time);
            }
            this.lev.Draw(this.time);
            if (this.lev.goalReached) {
                this.completed[this.curLevel] = true;
                boolean bl = true;
                int n5 = 0;
                while (n5 < this.completed.length) {
                    if (!this.completed[n5]) {
                        bl = false;
                    }
                    ++n5;
                }
                frogsport.println((String)"reached goal!");
                if (bl) {
                    this.gameState = this.GAME_END;
                } else if (this.curLevel + 1 < this.levels.length) {
                    this.lev = new Level(this.levels[++this.curLevel], this.s_offx, this.s_offy, this.s_tile_size_x, this.s_tile_size_y, this.s_s, this.time);
                    this.gameState = this.GAME_BETWEEN;
                    this.zPressedLast = this.keysDown[this.KEY_Z];
                } else {
                    this.gameState = this.GAME_INTRO;
                }
            }
            if (!this.slowMode || this.keysDown[this.KEY_RET] && !this.retPressedLast || this.keysDown[this.KEY_BACKSPACE]) {
                ++this.time;
            }
            this.retPressedLast = this.keysDown[this.KEY_RET];
            return;
        }
        if (this.gameState == this.GAME_END) {
            this.background(200.0f, 200.0f, 200.0f);
            this.fill(50.0f, 100.0f, 50.0f);
            this.words.DrawString(50.0f, 20.0f, "you win hooray", 5);
            this.words.DrawString(100.0f, 100.0f, "more levels coming soon probably", 1);
            float f = 170.0f;
            float f2 = f + 100.0f;
            this.fill(70.0f, 150.0f, 70.0f);
            this.stroke(200.0f, 100.0f, 0.0f);
            this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
            this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
            this.words.DrawString(100.0f, f + 50.0f, "you have won the game", 2);
            this.words.DrawString(100.0f, f + 65.0f, "or at least what is done so far", 2);
            this.words.DrawString(100.0f, f + 85.0f, "thanks for playing", 2);
            this.words.DrawString(100.0f, f + 100.0f, "you heartless global machine", 2);
            this.fill(200.0f, 200.0f, 0.0f);
            this.stroke(0.0f, 0.0f, 0.0f);
            this.rect(242.0f, f2 + 40.0f, 250.0f, 120.0f);
            this.fill(230.0f, 230.0f, 230.0f);
            this.stroke(0.0f, 0.0f, 0.0f);
            this.rect(285.0f, f2 + 50.0f, 180.0f, 70.0f);
            this.line(300.0f, f2 + 110.0f, 440.0f, f2 + 60.0f);
            this.words.DrawString(260.0f, f2 + 60.0f, "h", 3);
            this.words.DrawString(445.0f, f2 + 130.0f, "s", 3);
            this.words.DrawString(210.0f, f2 + 170.0f, "figure ten", 2);
            this.words.DrawString(210.0f, f2 + 185.0f, "i have not yet made up a figure", 2);
            this.words.DrawString(210.0f, f2 + 200.0f, "for the last level of the game", 2);
            return;
        }
        if (this.gameState == this.GAME_BETWEEN) {
            this.background(50.0f, 100.0f, 150.0f);
            this.fill(50.0f, 100.0f, 50.0f);
            if (this.keysDown[this.KEY_Z] && !this.zPressedLast) {
                this.gameState = this.GAME_PLAY;
            }
            this.zPressedLast = this.keysDown[this.KEY_Z];
            this.words.DrawString(80.0f, 50.0f, "level complete", 8);
            this.words.DrawString(100.0f, 110.0f, "for next level press z", 3);
            if (this.curLevel == 1) {
                float f = 170.0f;
                float f3 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "globalization has quickly replaced traditional", 2);
                this.words.DrawString(100.0f, f + 65.0f, "frog culture with a more modern human lifestyle", 2);
                this.words.DrawString(100.0f, f + 85.0f, "frogs have abandoned their wild hoppy ways and", 2);
                this.words.DrawString(100.0f, f + 100.0f, "now they march in unison with the global machine", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f3 + 40.0f, 250.0f, 120.0f);
                this.image(this.realfrog, 260.0f, f3 + 50.0f, this.realfrog.width * 5, this.realfrog.height * 5);
                this.fdata.idle[0].display(410.0f, f3 + 40.0f, 0, false, 5, false);
                this.words.DrawString(250.0f, f3 + 130.0f, "before", 3);
                this.words.DrawString(400.0f, f3 + 130.0f, "after", 3);
                this.words.DrawString(230.0f, f3 + 170.0f, "figure one", 2);
                this.words.DrawString(230.0f, f3 + 185.0f, "effects of globalization", 2);
                this.words.DrawString(230.0f, f3 + 200.0f, "on frog culture", 2);
            } else if (this.curLevel == 2) {
                float f = 170.0f;
                float f4 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "globalization has pressured female frogs to", 2);
                this.words.DrawString(100.0f, f + 65.0f, "submit to the fickle whims of human fashion", 2);
                this.words.DrawString(100.0f, f + 85.0f, "they dont know their lipstick was tested on ", 2);
                this.words.DrawString(100.0f, f + 100.0f, "captive lab frogs", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f4 + 40.0f, 250.0f, 120.0f);
                this.image(this.realfrog, 260.0f, f4 + 50.0f, this.realfrog.width * 5, this.realfrog.height * 5);
                this.fdata.idle[1].display(410.0f, f4 + 40.0f, 0, false, 5, false);
                this.words.DrawString(250.0f, f4 + 130.0f, "before", 3);
                this.words.DrawString(400.0f, f4 + 130.0f, "after", 3);
                this.words.DrawString(230.0f, f4 + 170.0f, "figure two", 2);
                this.words.DrawString(230.0f, f4 + 185.0f, "effects of globalization", 2);
                this.words.DrawString(230.0f, f4 + 200.0f, "on female frog fashions", 2);
            } else if (this.curLevel == 3) {
                float f = 170.0f;
                float f5 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 176, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "a sampling of cogs in the global machine confirms", 2);
                this.words.DrawString(100.0f, f + 65.0f, "the global machine is heartless", 2);
                this.words.DrawString(100.0f, f + 85.0f, "a statistically significant percentage do not worry", 2);
                this.words.DrawString(100.0f, f + 100.0f, "when frogs are squished for the greater good", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f5 + 40.0f, 250.0f, 120.0f);
                this.fill(230.0f, 230.0f, 230.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(400.0f, f5 + 110.0f, 40.0f, 10.0f);
                this.rect(290.0f, f5 + 50.0f, 40.0f, 70.0f);
                this.words.DrawString(395.0f, f5 + 133.0f, "yes", 3);
                this.words.DrawString(293.0f, f5 + 133.0f, "no", 3);
                this.words.DrawString(210.0f, f5 + 170.0f, "figure three", 2);
                this.words.DrawString(210.0f, f5 + 185.0f, "response to poll question", 2);
                this.words.DrawString(210.0f, f5 + 205.0f, "are you not heartless?", 2);
            } else if (this.curLevel == 4) {
                float f = 170.0f;
                float f6 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "the mating song is the one refuge of frogs from", 2);
                this.words.DrawString(100.0f, f + 65.0f, "the unending demands of the global machine", 2);
                this.words.DrawString(100.0f, f + 85.0f, "unfortunately the global machine has learned", 2);
                this.words.DrawString(100.0f, f + 100.0f, "to reproduce this mating song artificially", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f6 + 40.0f, 250.0f, 120.0f);
                this.fill(230.0f, 230.0f, 230.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(400.0f, f6 + 110.0f, 40.0f, 10.0f);
                this.rect(290.0f, f6 + 50.0f, 40.0f, 70.0f);
                this.words.DrawString(395.0f, f6 + 133.0f, "sex", 3);
                this.words.DrawString(255.0f, f6 + 133.0f, "no sex", 3);
                this.words.DrawString(210.0f, f6 + 170.0f, "figure four", 2);
                this.words.DrawString(210.0f, f6 + 200.0f, "frog responsiveness", 2);
                this.words.DrawString(210.0f, f6 + 185.0f, "effects of mating on", 2);
            } else if (this.curLevel == 5) {
                float f = 170.0f;
                float f7 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "the societal status of a male frog is equal", 2);
                this.words.DrawString(100.0f, f + 65.0f, "to the height from which it was born", 2);
                this.words.DrawString(100.0f, f + 85.0f, "the only use of a male frog beneath you", 2);
                this.words.DrawString(100.0f, f + 100.0f, "is to step on its head", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f7 + 40.0f, 250.0f, 120.0f);
                this.fill(230.0f, 230.0f, 230.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(285.0f, f7 + 50.0f, 180.0f, 70.0f);
                this.line(300.0f, f7 + 110.0f, 440.0f, f7 + 60.0f);
                this.words.DrawString(260.0f, f7 + 60.0f, "h", 3);
                this.words.DrawString(445.0f, f7 + 130.0f, "s", 3);
                this.words.DrawString(210.0f, f7 + 170.0f, "figure five", 2);
                this.words.DrawString(210.0f, f7 + 185.0f, "male frog social status s versus", 2);
                this.words.DrawString(210.0f, f7 + 200.0f, "initial height h in level", 2);
            } else if (this.curLevel == 6) {
                float f = 170.0f;
                float f8 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "the endless fertility of frogs is great", 2);
                this.words.DrawString(100.0f, f + 65.0f, "for filling pot holes", 2);
                this.words.DrawString(100.0f, f + 85.0f, "to the global machine frogs may as well be", 2);
                this.words.DrawString(100.0f, f + 100.0f, "some new form of pavement", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f8 + 40.0f, 250.0f, 120.0f);
                this.fill(230.0f, 230.0f, 230.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(400.0f, f8 + 110.0f, 40.0f, 10.0f);
                this.rect(275.0f, f8 + 50.0f, 40.0f, 70.0f);
                this.words.DrawString(365.0f, f8 + 133.0f, "asphalt", 3);
                this.words.DrawString(250.0f, f8 + 133.0f, "frogs", 3);
                this.words.DrawString(210.0f, f8 + 170.0f, "figure six", 2);
                this.words.DrawString(210.0f, f8 + 185.0f, "cost effectiveness of frogs", 2);
                this.words.DrawString(210.0f, f8 + 200.0f, "compared to asphalt", 2);
            } else if (this.curLevel == 7) {
                float f = 170.0f;
                float f9 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "at current exponential growth rates frogs", 2);
                this.words.DrawString(100.0f, f + 65.0f, "will soon be the majority species on earth ", 2);
                this.words.DrawString(100.0f, f + 85.0f, "shortly thereafter they will outnumber", 2);
                this.words.DrawString(100.0f, f + 100.0f, "the atoms in the universe", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f9 + 40.0f, 250.0f, 120.0f);
                this.fill(230.0f, 230.0f, 230.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(285.0f, f9 + 50.0f, 180.0f, 70.0f);
                this.line(300.0f, f9 + 60.0f, 302.0f, f9 + 110.0f);
                this.line(302.0f, f9 + 110.0f, 450.0f, f9 + 110.0f);
                this.words.DrawString(260.0f, f9 + 60.0f, "s", 3);
                this.words.DrawString(445.0f, f9 + 130.0f, "t", 3);
                this.words.DrawString(210.0f, f9 + 170.0f, "figure eight", 2);
                this.words.DrawString(210.0f, f9 + 185.0f, "space in universe not occupied by frogs s", 2);
                this.words.DrawString(210.0f, f9 + 200.0f, "plotted against time t", 2);
            } else if (this.curLevel == 8) {
                float f = 170.0f;
                float f10 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 50.0f, "before globalization frogs had a rich swimming", 2);
                this.words.DrawString(100.0f, f + 65.0f, "tradition and were some of the worlds ", 2);
                this.words.DrawString(100.0f, f + 80.0f, "best known amphibians", 2);
                this.words.DrawString(100.0f, f + 100.0f, "now they can hardly hold their breath", 2);
                this.words.DrawString(100.0f, f + 115.0f, "for even a few seconds underwater", 2);
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(242.0f, f10 + 40.0f, 250.0f, 120.0f);
                this.fill(230.0f, 230.0f, 230.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(285.0f, f10 + 50.0f, 180.0f, 70.0f);
                this.line(300.0f, f10 + 60.0f, 440.0f, f10 + 110.0f);
                this.words.DrawString(260.0f, f10 + 60.0f, "s", 3);
                this.words.DrawString(445.0f, f10 + 130.0f, "g", 3);
                this.words.DrawString(210.0f, f10 + 170.0f, "figure eight", 2);
                this.words.DrawString(210.0f, f10 + 185.0f, "frog swimming ability s with respect to", 2);
                this.words.DrawString(210.0f, f10 + 200.0f, "level of globalization g", 2);
            } else if (this.curLevel == 9) {
                float f = 170.0f;
                float f11 = f + 100.0f;
                this.fill(70.0f, 150.0f, 70.0f);
                this.stroke(200.0f, 100.0f, 0.0f);
                this.rect(90.0f, f, this.width - 180, (float)this.height - f - 100.0f);
                this.words.DrawString(200.0f, f + 10.0f, "did you know?", 5);
                this.words.DrawString(100.0f, f + 65.0f, "frogs are an excellent new organic material", 2);
                this.words.DrawString(100.0f, f + 80.0f, "for building bridges ", 2);
                float f12 = this.frogW * 3 / 2 - 5;
                float f13 = this.frogH * 3 / 2 - 1;
                float f14 = 280.0f;
                this.fill(200.0f, 200.0f, 0.0f);
                this.stroke(0.0f, 0.0f, 0.0f);
                this.rect(245.0f, f11 + 10.0f, 190.0f, 155.0f);
                this.fdata.idle[0].display(f14, f11 + 110.0f, 0, false, 3, true);
                this.fdata.idle[1].display(f14 + f12, f11 + 110.0f - f13, 0, false, 3, true);
                this.fdata.idle[0].display(f14 + 2.0f * f12, f11 + 110.0f - f13 * 2.0f, 0, false, 3, true);
                this.fdata.idle[1].display(f14 + 3.0f * f12, f11 + 110.0f - f13, 0, false, 3, false);
                this.fdata.idle[0].display(f14 + 4.0f * f12, f11 + 110.0f, 0, false, 3, false);
                this.words.DrawString(210.0f, f11 + 173.0f, "figure nine", 2);
                this.words.DrawString(210.0f, f11 + 188.0f, "spiky bridge is made of frogs", 2);
            }
            return;
        }
        this.background(128.0f, 0.0f, 0.0f);
        this.fill(0);
        this.stroke(0);
        ++this.time;
    }

    public void keyPressed() {
        int n = this.key - 48;
        if (n >= 0 && n <= 6) {
            this.curLevel = n;
            this.lev = new Level(this.levels[this.curLevel], this.s_offx, this.s_offy, this.s_tile_size_x, this.s_tile_size_y, this.s_s, this.time);
        }
        if (this.key == '\u001b') {
            this.key = (char)113;
        }
        if (this.key == 'q' || this.key == 'Q') {
            this.gameState = this.GAME_INTRO;
        }
        if (this.key == '\r' || this.key == '\n') {
            this.keysDown[this.KEY_RET] = true;
        }
        if (this.key == '\b') {
            this.keysDown[this.KEY_BACKSPACE] = true;
        }
        if (this.key == ' ') {
            this.keysDown[this.KEY_SPACE] = true;
        }
        if (this.key == 'Z' || this.key == 'z') {
            this.keysDown[this.KEY_Z] = true;
        }
        if (this.key == 'R' || this.key == 'r') {
            this.keysDown[this.KEY_R] = true;
        }
        if (this.key == '\uffff') {
            if (this.keyCode == 37) {
                this.keysDown[this.KEY_LEFT] = true;
            }
            if (this.keyCode == 39) {
                this.keysDown[this.KEY_RIGHT] = true;
            }
            if (this.keyCode == 38) {
                this.keysDown[this.KEY_UP] = true;
            }
            if (this.keyCode == 40) {
                this.keysDown[this.KEY_DOWN] = true;
            }
        }
    }

    public void keyReleased() {
        if (this.key == '\r' || this.key == '\n') {
            this.keysDown[this.KEY_RET] = false;
        }
        if (this.key == '\b') {
            this.keysDown[this.KEY_BACKSPACE] = false;
        }
        if (this.key == ' ') {
            this.keysDown[this.KEY_SPACE] = false;
        }
        if (this.key == 'Z' || this.key == 'z') {
            this.keysDown[this.KEY_Z] = false;
        }
        if (this.key == 'R' || this.key == 'r') {
            this.keysDown[this.KEY_R] = false;
        }
        if (this.key == '\uffff') {
            if (this.keyCode == 37) {
                this.keysDown[this.KEY_LEFT] = false;
            }
            if (this.keyCode == 39) {
                this.keysDown[this.KEY_RIGHT] = false;
            }
            if (this.keyCode == 38) {
                this.keysDown[this.KEY_UP] = false;
            }
            if (this.keyCode == 40) {
                this.keysDown[this.KEY_DOWN] = false;
            }
        }
    }

    public Animation loadAnimation(String string) {
        return new Animation(String.valueOf(string) + ".gif", String.valueOf(string) + ".csv");
    }

    public void imageFlip(PImage pImage, float f, float f2, float f3, float f4) {
        this.pushMatrix();
        this.scale(-1.0f, 1.0f);
        this.image(pImage, -f, f2, -f3, f4);
        this.popMatrix();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "frogsport"});
    }

    class Animation {
        PImage[] images;
        PImage[] palswapped;
        int[] duration;
        int imageCount;
        int totalFrames;
        int w;
        int h;
        boolean inited;
        PImage bigImage;
        String[] lines;
        String csvFile;
        int timeScale = 2;

        Animation(String string, String string2) {
            this.csvFile = string2;
            this.lines = frogsport.this.loadStrings(this.csvFile);
            this.bigImage = frogsport.this.managedRequestImage(string);
            this.inited = false;
        }

        public void init() {
            this.imageCount = this.lines.length - 1;
            this.images = new PImage[this.imageCount];
            this.palswapped = new PImage[this.imageCount];
            this.duration = new int[this.imageCount];
            this.w = this.bigImage.width;
            this.h = this.bigImage.height / this.imageCount;
            this.totalFrames = 0;
            frogsport.println((String)(String.valueOf(this.csvFile) + " has " + this.lines.length + " lines"));
            int n = 1;
            while (n < this.lines.length) {
                String[] stringArray = frogsport.split((String)this.lines[n], (char)'\"');
                if (stringArray.length > 0) {
                    this.duration[n - 1] = PApplet.parseInt((String)stringArray[1]);
                    this.totalFrames += this.duration[n - 1];
                    this.images[n - 1] = this.bigImage.get(0, this.h * (n - 1), this.w, this.h);
                    this.palswapped[n - 1] = this.bigImage.get(0, this.h * (n - 1), this.w, this.h);
                    this.palswapped[n - 1].loadPixels();
                    int n2 = 0;
                    while (n2 < this.palswapped[n - 1].pixels.length) {
                        int n3 = this.palswapped[n - 1].pixels[n2];
                        if (frogsport.this.green(n3) - frogsport.this.red(n3) - frogsport.this.blue(n3) > 129.0f) {
                            this.palswapped[n - 1].pixels[n2] = frogsport.this.color(frogsport.this.red(n3), frogsport.this.green(n3), frogsport.this.green(n3));
                        }
                        ++n2;
                    }
                    this.palswapped[n - 1].updatePixels();
                }
                ++n;
            }
            frogsport.println((String)(String.valueOf(this.csvFile) + " totalFrames = " + this.totalFrames));
            this.inited = true;
        }

        public int timeToImageNumber(int n, boolean bl) {
            if (!this.inited) {
                this.init();
            }
            if (!bl && n >= this.totalFrames) {
                return this.imageCount - 1;
            }
            n %= this.totalFrames;
            int n2 = 0;
            int n3 = 0;
            while (n > n2 + this.duration[n3]) {
                n2 += this.duration[n3];
                ++n3;
            }
            return n3;
        }

        public void setTimeScale(int n) {
            this.timeScale = n;
        }

        public float percent(int n) {
            if (!this.inited) {
                this.init();
            }
            return frogsport.min((float)1.0f, (float)(PApplet.parseFloat((int)(n * this.timeScale)) / PApplet.parseFloat((int)this.totalFrames)));
        }

        public boolean isDone(int n) {
            if (!this.inited) {
                this.init();
            }
            return n * this.timeScale >= this.totalFrames;
        }

        public void display(float f, float f2, int n, boolean bl, int n2, boolean bl2) {
            if (!this.inited) {
                this.init();
            }
            int n3 = this.timeToImageNumber(n * this.timeScale, bl);
            int n4 = 1;
            if (bl2) {
                frogsport.this.pushMatrix();
                frogsport.this.scale(-1.0f, 1.0f);
                n4 = -1;
            }
            if (!frogsport.this.g_pswap) {
                frogsport.this.image(this.images[n3], (float)n4 * f, f2, n4 * this.w * n2, this.h * n2);
            } else {
                frogsport.this.image(this.palswapped[n3], (float)n4 * f, f2, n4 * this.w * n2, this.h * n2);
            }
            if (bl2) {
                frogsport.this.popMatrix();
            }
        }

        public int getWidth() {
            if (!this.inited) {
                this.init();
            }
            return this.images[0].width;
        }
    }

    class CapsFont {
        PImage[] images;
        int w;
        int h;
        PImage bigImage;
        boolean inited;

        public void init() {
            int n = 27;
            this.images = new PImage[n];
            this.w = this.bigImage.width / n;
            this.h = this.bigImage.height;
            frogsport.println((String)("w = " + this.w + " h = " + this.h));
            int n2 = 0;
            while (n2 < 27) {
                this.images[n2] = this.bigImage.get(this.w * n2, 0, this.w, this.h);
                ++n2;
            }
            this.inited = true;
        }

        CapsFont(String string) {
            this.bigImage = frogsport.this.managedRequestImage(string);
            this.inited = false;
        }

        public void DrawInt(float f, float f2, int n, int n2) {
            if (!this.inited) {
                this.init();
            }
            frogsport.this.image(this.images[n], f, f2, this.w * n2, this.h * n2);
        }

        public void DrawChar(float f, float f2, char c, int n) {
            if (c == '?') {
                this.DrawInt(f, f2, 26, n);
            } else {
                int n2 = PApplet.parseInt((char)c);
                if (n2 > 91) {
                    n2 -= 32;
                }
                if ((n2 -= 65) >= 0 && n2 < 26) {
                    this.DrawInt(f, f2, n2, n);
                }
            }
        }

        public void DrawString(float f, float f2, String string, int n) {
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                this.DrawChar(f + (float)(n3 * this.w * n), f2, string.charAt(n3), n);
                ++n3;
            }
        }
    }

    class Dude {
        float xpos;
        float ypos;
        boolean flip;
        Animation move;
        Animation idle;
        Animation talk;
        int state;
        int wallhit = 0;

        Dude(float f, float f2) {
            this.xpos = f;
            this.ypos = f2;
            this.move = frogsport.this.loadAnimation("guywalk");
            this.idle = frogsport.this.loadAnimation("guyidle");
            this.talk = frogsport.this.loadAnimation("emerge2");
            this.state = frogsport.this.FSTATE_IDLE;
            this.flip = true;
        }

        public void Update() {
        }

        public void WallHit(int n) {
            this.wallhit = n;
        }

        public void DrawNoInput(int n, int n2) {
            if (this.state == frogsport.this.FSTATE_MOVE) {
                this.move.display(this.xpos, this.ypos, n, true, n2, this.flip);
            }
            if (this.state == frogsport.this.FSTATE_IDLE) {
                this.idle.display(this.xpos, this.ypos, n, true, n2, this.flip);
            }
            if (this.state == frogsport.this.FSTATE_TALK) {
                this.talk.display(this.xpos, this.ypos, n, true, n2, this.flip);
            }
        }

        public void Draw(int n, int n2) {
            if (frogsport.this.keysDown[frogsport.this.KEY_RIGHT] || frogsport.this.keysDown[frogsport.this.KEY_LEFT]) {
                this.state = frogsport.this.FSTATE_MOVE;
                boolean bl = false;
                if (this.wallhit != -1 && frogsport.this.keysDown[frogsport.this.KEY_LEFT]) {
                    this.flip = false;
                    this.xpos -= (float)(1 * n2);
                    bl = true;
                }
                if (this.wallhit != 1 && frogsport.this.keysDown[frogsport.this.KEY_RIGHT]) {
                    this.flip = true;
                    this.xpos += (float)(1 * n2);
                    bl = true;
                }
                if (bl) {
                    this.move.display(this.xpos, this.ypos, n, true, n2, this.flip);
                } else {
                    this.state = frogsport.this.FSTATE_IDLE;
                }
            } else if (this.state == frogsport.this.FSTATE_MOVE) {
                this.state = frogsport.this.FSTATE_IDLE;
            }
            if (this.state == frogsport.this.FSTATE_IDLE) {
                this.idle.display(this.xpos, this.ypos, n, true, n2, this.flip);
            }
            if (this.state == frogsport.this.FSTATE_TALK) {
                this.talk.display(this.xpos, this.ypos, n, true, n2, this.flip);
            }
            this.wallhit = 0;
        }
    }

    class Frog {
        boolean flip;
        float x;
        float y;
        float vx;
        float vy;
        int state;
        int gender;
        boolean wantsBaby;
        int stateStartTime = 0;
        Frog partner;
        Frog baby;
        boolean dead;
        boolean pswap;

        Frog(float f, float f2, int n, boolean bl) {
            if (frogsport.this.fdata == null) {
                frogsport.this.fdata = new FrogData();
            }
            this.x = f;
            this.y = f2;
            this.gender = n;
            this.partner = null;
            this.state = frogsport.this.STATE_IDLE;
            this.flip = true;
            this.pswap = bl;
        }

        public float dynamicH(int n) {
            if (this.state != frogsport.this.STATE_EMERGE) {
                return frogsport.this.frogH;
            }
            float f = frogsport.this.fdata.emerge.percent(n - this.stateStartTime);
            return frogsport.max((float)3.0f, (float)((float)frogsport.this.frogH * f));
        }

        public float dynamicY(int n) {
            if (this.state != frogsport.this.STATE_EMERGE) {
                return this.y;
            }
            float f = frogsport.this.fdata.emerge.percent(n - this.stateStartTime);
            return this.y + frogsport.min((float)(frogsport.this.frogH - 3), (float)((1.0f - f) * (float)frogsport.this.frogH));
        }

        public void setDynamicY(float f, int n) {
            if (this.state != frogsport.this.STATE_EMERGE) {
                this.y = f;
            } else {
                float f2 = frogsport.this.fdata.emerge.percent(n - this.stateStartTime);
                this.y = f - frogsport.min((float)(frogsport.this.frogH - 3), (float)((1.0f - f2) * (float)frogsport.this.frogH));
                this.dynamicY(n);
            }
        }

        public void UpdateStateAndGoals(int n, int n2, int n3) {
            this.wantsBaby = false;
            this.baby = null;
            this.vx = 0.0f;
            if (this.state == frogsport.this.STATE_PREP) {
                if (frogsport.this.fdata.prep[this.gender].isDone(n - this.stateStartTime)) {
                    this.stateStartTime = n;
                    this.state = frogsport.this.STATE_CENS;
                }
            } else if (this.state == frogsport.this.STATE_CENS) {
                if (n - this.stateStartTime > frogsport.this.CENSOR_TIME) {
                    this.stateStartTime = n;
                    this.state = this.gender == frogsport.this.GIRL ? frogsport.this.STATE_BABY : frogsport.this.STATE_IDLE;
                }
            } else if (this.state == frogsport.this.STATE_BABY) {
                if (frogsport.this.fdata.baby.isDone(n - this.stateStartTime)) {
                    this.state = frogsport.this.STATE_IDLE;
                    this.stateStartTime = n;
                    if (this.gender == frogsport.this.GIRL) {
                        this.baby = new Frog(this.x, this.y, n3, this.pswap);
                        this.baby.stateStartTime = n;
                        this.baby.flip = this.flip;
                    }
                }
            } else if (this.state == frogsport.this.STATE_EMERGE && frogsport.this.fdata.emerge.isDone(n - this.stateStartTime)) {
                this.state = frogsport.this.STATE_IDLE;
                this.stateStartTime = n;
            }
            if (this.state == frogsport.this.STATE_IDLE || this.state == frogsport.this.STATE_WALK) {
                if (frogsport.this.keysDown[frogsport.this.KEY_RIGHT] || frogsport.this.keysDown[frogsport.this.KEY_LEFT]) {
                    this.state = frogsport.this.STATE_WALK;
                    this.vx = 0.0f;
                    if (frogsport.this.keysDown[frogsport.this.KEY_RIGHT]) {
                        this.vx += (float)(2 * n2);
                        this.flip = true;
                    }
                    if (frogsport.this.keysDown[frogsport.this.KEY_LEFT]) {
                        this.vx -= (float)(2 * n2);
                        this.flip = false;
                    }
                } else {
                    this.state = frogsport.this.STATE_IDLE;
                }
                if (frogsport.this.keysDown[frogsport.this.KEY_Z]) {
                    this.stateStartTime = n;
                    this.wantsBaby = true;
                }
            }
        }

        public void Draw(int n, int n2) {
            frogsport.this.g_pswap = this.pswap;
            if (this.state == frogsport.this.STATE_IDLE) {
                frogsport.this.fdata.idle[this.gender].display(this.x, this.y - 1.0f, n, true, n2, this.flip);
            } else if (this.state == frogsport.this.STATE_WALK) {
                frogsport.this.fdata.walk[this.gender].display(this.x, this.y - 1.0f, n, true, n2, this.flip);
            } else if (this.state == frogsport.this.STATE_PREP) {
                if (this.partner.state != frogsport.this.STATE_CENS) {
                    frogsport.this.fdata.prep[this.gender].display(this.x, this.y - 1.0f, n - this.stateStartTime, false, n2, this.flip);
                }
            } else if (this.state == frogsport.this.STATE_CENS) {
                if (this.gender == frogsport.this.GIRL) {
                    int n3 = 0;
                    if (this.flip) {
                        n3 = -frogsport.this.frogW;
                    }
                    frogsport.this.display(frogsport.this.fdata.censor, (int)this.x + n3, (int)this.y - 1, n2, false);
                } else if (this.partner.state != frogsport.this.STATE_CENS) {
                    frogsport.this.fdata.idle[this.gender].display(this.x, this.y - 1.0f, n, true, n2, this.flip);
                }
            } else if (this.state == frogsport.this.STATE_BABY) {
                frogsport.this.fdata.baby.display(this.x, this.y - 1.0f, n - this.stateStartTime, false, n2, this.flip);
            } else if (this.state == frogsport.this.STATE_EMERGE) {
                frogsport.this.fdata.emerge.display(this.x, this.y - 1.0f, n - this.stateStartTime, false, n2, this.flip);
            } else if (this.state == frogsport.this.STATE_DEAD) {
                frogsport.this.fdata.squish[this.gender].display(this.x, this.y - 1.0f, n - this.stateStartTime, false, n2, this.flip);
            } else if (this.state == frogsport.this.STATE_DROWNED) {
                frogsport.this.fdata.drown[this.gender].display(this.x, this.y - 1.0f, n - this.stateStartTime, false, n2, this.flip);
            }
            frogsport.this.g_pswap = false;
        }
    }

    class FrogData {
        Animation[] idle = new Animation[2];
        Animation[] walk;
        Animation[] prep;
        Animation[] squish;
        Animation[] drown;
        Animation baby;
        Animation emerge;
        PImage censor;

        FrogData() {
            this.idle[0] = frogsport.this.loadAnimation("guyidle");
            this.idle[1] = frogsport.this.loadAnimation("girlidle");
            this.walk = new Animation[2];
            this.walk[0] = frogsport.this.loadAnimation("guywalk");
            this.walk[1] = frogsport.this.loadAnimation("girlwalk");
            this.prep = new Animation[2];
            this.prep[0] = frogsport.this.loadAnimation("guypre");
            this.prep[1] = frogsport.this.loadAnimation("girlpre");
            this.squish = new Animation[2];
            this.squish[0] = frogsport.this.loadAnimation("guysquish");
            this.squish[1] = frogsport.this.loadAnimation("girlsquish");
            this.drown = new Animation[2];
            this.drown[0] = frogsport.this.loadAnimation("guydrown");
            this.drown[1] = frogsport.this.loadAnimation("girldrown");
            this.emerge = frogsport.this.loadAnimation("emerge2");
            this.emerge.setTimeScale(1);
            this.baby = frogsport.this.loadAnimation("baby");
            this.censor = frogsport.this.managedRequestImage("censor.gif");
        }
    }

    class FrogXComparator
    implements Comparator {
        int o;

        FrogXComparator(int n) {
            this.o = n;
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof Frog) || !(object2 instanceof Frog)) {
                frogsport.println((String)"only give me frogs!");
                return 0;
            }
            Frog frog = (Frog)object;
            Frog frog2 = (Frog)object2;
            if (frog.x * (float)this.o < frog2.x * (float)this.o) {
                return -1;
            }
            if (frog.x * (float)this.o > frog2.x * (float)this.o) {
                return 1;
            }
            if (frog.hashCode() > frog2.hashCode()) {
                return 1;
            }
            if (frog.hashCode() < frog2.hashCode()) {
                return -1;
            }
            return 0;
        }
    }

    class FrogYComparator
    implements Comparator {
        int o;
        int t;

        FrogYComparator(int n, int n2) {
            this.o = n;
            this.t = n2;
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof Frog) || !(object2 instanceof Frog)) {
                frogsport.println((String)"only give me frogs!");
                return 0;
            }
            Frog frog = (Frog)object;
            Frog frog2 = (Frog)object2;
            if (frog.dynamicY(this.t) * (float)this.o < frog2.dynamicY(this.t) * (float)this.o) {
                return -1;
            }
            if (frog.dynamicY(this.t) * (float)this.o > frog2.dynamicY(this.t) * (float)this.o) {
                return 1;
            }
            if (frog.hashCode() > frog2.hashCode()) {
                return 1;
            }
            if (frog.hashCode() < frog2.hashCode()) {
                return -1;
            }
            return 0;
        }
    }

    class Level {
        int w;
        int h;
        int[] tiles;
        ArrayList frogs;
        boolean goalReached;
        int activeGender;
        boolean hasWater;
        int waterHeight;
        int timeStart;
        float offx;
        float offy;
        int tile_size_x;
        int tile_size_y;
        int s;
        int topLeeway = 10;

        public int xyToI(int n, int n2) {
            return n2 * this.w + n;
        }

        public int iToX(int n) {
            return n % this.w;
        }

        public int iToY(int n) {
            return n / this.w;
        }

        Level(String string, float f, float f2, int n, int n2, int n3, int n4) {
            this.timeStart = n4;
            this.hasWater = false;
            this.waterHeight = 20;
            this.offx = f;
            this.offy = f2;
            this.tile_size_x = n;
            this.tile_size_y = n2;
            this.s = n3;
            this.activeGender = 0;
            this.loadMap(string);
            this.goalReached = false;
        }

        public boolean frogFrogOverlap(Frog frog, Frog frog2, float f, float f2, int n) {
            if (frog.state == frogsport.this.STATE_DEAD || frog2.state == frogsport.this.STATE_DEAD) {
                return false;
            }
            float f3 = frog.dynamicY(n);
            float f4 = frog2.dynamicY(n);
            return frogsport.this.rectOverlap(frog.x + f, f3, frog.x + f + (float)frogsport.this.frogW, f3 + frog.dynamicH(n) + f2 - 1.0f, frog2.x, f4, frog2.x + (float)frogsport.this.frogW, f4 + frog2.dynamicH(n) - 1.0f);
        }

        public boolean frogFrogColliding(Frog frog, float f, float f2, int n) {
            int n2 = 0;
            while (n2 < this.frogs.size()) {
                Frog frog2 = (Frog)this.frogs.get(n2);
                if (frog2 != frog && (frog2.state == frogsport.this.STATE_EMERGE && n - frog2.stateStartTime <= 5 || this.Colliding(frog2, 0.0f, 0.0f, n, true) != frogsport.this.TILE_WALL) && this.frogFrogOverlap(frog, frog2, f, f2, n)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int Colliding(Frog frog, float f, float f2, int n, boolean bl) {
            int n2 = frogsport.this.frogW;
            int n3 = frogsport.this.frogH;
            if (bl) {
                n3 = 1;
            }
            float f3 = frog.x + f;
            float f4 = frog.dynamicY(n) + f2;
            int n4 = (int)f3;
            int n5 = (int)f4;
            int n6 = frogsport.this.TILE_NONE;
            int n7 = n4;
            while (n7 <= n4 + n2 + this.tile_size_x * this.s) {
                int n8 = n7;
                if (n7 > n4 + n2) {
                    n8 = n4 + n2;
                }
                int n9 = (int)(((float)n8 - this.offx) / (float)(this.tile_size_x * this.s));
                if ((float)n8 < this.offx) {
                    return frogsport.this.TILE_WALL;
                }
                int n10 = n5 + this.topLeeway;
                while (n10 <= n5 + n3 + this.tile_size_y * this.s) {
                    int n11 = n10;
                    if (n10 >= n5 + n3) {
                        n11 = n5 + n3 - 1;
                    }
                    if ((float)n11 < this.offy) {
                        return frogsport.this.TILE_WALL;
                    }
                    int n12 = (int)(((float)n5 - this.offy) / (float)(this.tile_size_y * this.s));
                    int n13 = (int)(((float)(n5 + n3 - 1) - this.offy) / (float)(this.tile_size_y * this.s));
                    int n14 = (int)(((float)n11 - this.offy) / (float)(this.tile_size_y * this.s));
                    int n15 = this.xyToI(n9, n14);
                    if (n14 >= this.h) {
                        return frogsport.this.TILE_NONE;
                    }
                    if (n9 < 0 || n14 < 0 || n9 >= this.w || n14 >= this.h || n15 < 0 || n15 >= this.tiles.length) {
                        return frogsport.this.TILE_WALL;
                    }
                    if (this.tiles[n15] != frogsport.this.TILE_NONE) {
                        if (this.tiles[n15] == frogsport.this.TILE_WALL) {
                            return frogsport.this.TILE_WALL;
                        }
                        if (this.tiles[n15] == frogsport.this.TILE_CIEL) {
                            if (n14 == n13 && n13 != n12) {
                                n6 = frogsport.this.TILE_CIEL;
                            }
                        } else {
                            n6 = this.tiles[n15];
                        }
                    }
                    n10 += this.tile_size_y * this.s - 1;
                }
                n7 += this.tile_size_x * this.s - 1;
            }
            if (bl) {
                return n6;
            }
            if (this.frogFrogColliding(frog, f, f2, n)) {
                return frogsport.this.TILE_FROG;
            }
            return n6;
        }

        public void loadMap(String string) {
            this.frogs = new ArrayList();
            String[] stringArray = frogsport.this.loadStrings(string);
            String[] stringArray2 = frogsport.split((String)stringArray[0], (char)' ');
            if (stringArray2.length < 2) {
                frogsport.println((String)"failed to read map; expected dimensions on first line");
                return;
            }
            this.w = PApplet.parseInt((String)stringArray2[0]);
            this.h = PApplet.parseInt((String)stringArray2[1]);
            this.offx = (frogsport.this.width - this.w * this.tile_size_x * this.s) / 2;
            char c = stringArray2[2].charAt(0);
            this.activeGender = c == 'F' || c == 'W' ? frogsport.this.GIRL : frogsport.this.BOY;
            if (stringArray2.length >= 4 && stringArray2[3].length() > 0 && stringArray2[3].charAt(0) == 'W') {
                this.hasWater = true;
            }
            this.tiles = new int[this.w * this.h];
            int n = 1;
            while (n < 1 + this.h) {
                stringArray2 = frogsport.split((String)stringArray[n], (char)' ');
                if (stringArray2.length == 0) {
                    frogsport.println((String)"empty line where row of map expected");
                    return;
                }
                if (stringArray2[0].length() != this.w) {
                    frogsport.println((String)"row of incorrect length");
                    return;
                }
                int n2 = 0;
                while (n2 < stringArray2[0].length()) {
                    if ('M' == stringArray2[0].charAt(n2)) {
                        frogsport.println((String)(String.valueOf(this.offx) + ", " + this.offy));
                        frogsport.println((String)("pos = " + ((float)(n2 * this.tile_size_x * this.s) + this.offx) + ", " + ((float)(n * this.tile_size_y * this.s) + this.offy)));
                        this.frogs.add(new Frog((float)(n2 * this.tile_size_x * this.s) + this.offx, (float)((n - 1) * this.tile_size_y * this.s) + this.offy, frogsport.this.BOY, false));
                    } else if ('N' == stringArray2[0].charAt(n2)) {
                        this.frogs.add(new Frog((float)(n2 * this.tile_size_x * this.s) + this.offx, (float)((n - 1) * this.tile_size_y * this.s) + this.offy, frogsport.this.BOY, true));
                    } else if ('Q' == stringArray2[0].charAt(n2)) {
                        this.frogs.add(new Frog((float)(n2 * this.tile_size_x * this.s) + this.offx, (float)((n - 1) * this.tile_size_y * this.s) + this.offy, frogsport.this.GIRL, true));
                    } else if ('W' == stringArray2[0].charAt(n2)) {
                        this.frogs.add(new Frog((float)(n2 * this.tile_size_x * this.s) + this.offx, (float)((n - 1) * this.tile_size_y * this.s) + this.offy, frogsport.this.GIRL, false));
                    } else {
                        this.tiles[this.xyToI((int)n2, (int)(n - 1))] = 'J' == stringArray2[0].charAt(n2) ? frogsport.this.TILE_WALL : ('^' == stringArray2[0].charAt(n2) ? frogsport.this.TILE_CIEL : ('G' == stringArray2[0].charAt(n2) ? frogsport.this.TILE_GOAL : frogsport.this.TILE_NONE));
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public void SetTileColor(int n, int n2, boolean bl) {
            if ((n + n2) % 2 == 0) {
                if (bl) {
                    frogsport.this.fill(83.0f, 83.0f, 0.0f);
                } else {
                    frogsport.this.fill(133.0f, 250.0f, 183.0f);
                }
            } else if (bl) {
                frogsport.this.fill(0.0f, 64.0f, 64.0f);
            } else {
                frogsport.this.fill(0.0f, 255.0f, 128.0f);
            }
        }

        public void Update(int n) {
            Frog frog;
            int n2;
            this.waterHeight = (n - this.timeStart) / 4;
            if (this.hasWater) {
                n2 = 0;
                while (n2 < this.frogs.size()) {
                    if (((Frog)this.frogs.get((int)n2)).y > this.offy + (float)(this.h * this.tile_size_y * this.s) - (float)this.waterHeight && ((Frog)this.frogs.get((int)n2)).state != frogsport.this.STATE_DROWNED) {
                        ((Frog)this.frogs.get((int)n2)).state = frogsport.this.STATE_DROWNED;
                        ((Frog)this.frogs.get((int)n2)).stateStartTime = n;
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < this.frogs.size()) {
                ((Frog)this.frogs.get(n2)).UpdateStateAndGoals(n, this.s, this.activeGender);
                ++n2;
            }
            n2 = 1;
            if (frogsport.this.keysDown[frogsport.this.KEY_LEFT]) {
                n2 = -1;
            }
            TreeSet treeSet = new TreeSet(new FrogXComparator(n2));
            int n3 = 0;
            while (n3 < this.frogs.size()) {
                treeSet.add(this.frogs.get(n3));
                ++n3;
            }
            for (Frog frog2 : treeSet) {
                float f = 0.0f;
                int n4 = 1;
                if (frog2.vx < 0.0f) {
                    n4 = -1;
                }
                float f2 = f;
                while ((float)n4 * f < (float)n4 * frog2.vx && this.Colliding(frog2, f + (float)(n4 * 4), 0.0f, n, false) < frogsport.this.TILE_WALL) {
                    f2 = f;
                    f += (float)n4;
                }
                frog2.x += f2;
            }
            int n5 = this.frogs.size();
            int n6 = 0;
            while (n6 < n5) {
                Frog frog3 = (Frog)this.frogs.get(n6);
                if (frog3.baby != null) {
                    this.frogs.add(frog3.baby);
                    frog3.baby.state = frogsport.this.STATE_EMERGE;
                    frog3.baby.stateStartTime = n;
                    frog3.y -= 2.0f;
                    frog3.baby = null;
                }
                ++n6;
            }
            TreeSet treeSet2 = new TreeSet(new FrogYComparator(-1, n));
            n6 = 0;
            while (n6 < this.frogs.size()) {
                treeSet2.add(this.frogs.get(n6));
                ++n6;
            }
            for (Frog frog4 : treeSet2) {
                if (frog4.state == frogsport.this.STATE_DEAD) continue;
                int n7 = 0;
                while (n7 < this.frogs.size()) {
                    frog = (Frog)this.frogs.get(n7);
                    if (frog4 != frog && frog.state != frogsport.this.STATE_DEAD && this.frogFrogOverlap(frog4, frog, 0.0f, 0.0f, n)) {
                        frog.setDynamicY(frog4.dynamicY(n) - frog.dynamicH(n) - 1.0f, n);
                        if (frog.state == frogsport.this.STATE_PREP || frog.state == frogsport.this.STATE_CENS) {
                            frog.partner.y = frog.y;
                        }
                    }
                    ++n7;
                }
            }
            treeSet2 = new TreeSet(new FrogYComparator(-1, n));
            int n8 = 0;
            while (n8 < this.frogs.size()) {
                treeSet2.add(this.frogs.get(n8));
                ++n8;
            }
            for (Frog frog5 : treeSet2) {
                float f = 0.0f;
                int n9 = 1;
                frog5.vy += (float)(this.s * 1);
                if (frog5.vy < 0.0f) {
                    n9 = -1;
                }
                if (frog5.vy > (float)(this.s * 10)) {
                    frog5.vy = this.s * 10;
                }
                float f3 = f;
                boolean bl = false;
                int n10 = this.Colliding(frog5, 0.0f, f, n, false);
                int n11 = frogsport.this.TILE_NONE;
                if (frog5.state == frogsport.this.STATE_PREP || frog5.state == frogsport.this.STATE_CENS) {
                    n11 = this.Colliding(frog5.partner, 0.0f, f, n, false);
                }
                while ((float)n9 * f < (float)n9 * frog5.vy) {
                    boolean bl2;
                    int n12 = this.Colliding(frog5, 0.0f, f, n, false);
                    boolean bl3 = bl2 = n12 == frogsport.this.TILE_WALL || n12 == frogsport.this.TILE_FROG || n9 > 0 && n10 == frogsport.this.TILE_NONE && n12 == frogsport.this.TILE_CIEL;
                    if (!(bl2 || frog5.state != frogsport.this.STATE_PREP && frog5.state != frogsport.this.STATE_CENS)) {
                        int n13 = this.Colliding(frog5.partner, 0.0f, f, n, false);
                        bl2 = n13 == frogsport.this.TILE_WALL || n13 == frogsport.this.TILE_FROG || n9 > 0 && n11 == frogsport.this.TILE_NONE && n13 == frogsport.this.TILE_CIEL;
                        n11 = n13;
                    }
                    if (bl2) {
                        bl = true;
                        break;
                    }
                    f3 = f;
                    f += (float)n9;
                    n10 = n12;
                }
                if (bl) {
                    frog5.vy = 0.0f;
                }
                frog5.y += f3;
                if (frog5.state != frogsport.this.STATE_PREP && frog5.state != frogsport.this.STATE_CENS || frog5.partner.state != frogsport.this.STATE_PREP && frog5.partner.state != frogsport.this.STATE_CENS || frog5.y == frog5.partner.y || frog5.gender != frogsport.this.GIRL) continue;
                frog5.partner.y = frog5.y;
            }
            int n14 = 0;
            while (n14 < this.frogs.size()) {
                Frog frog6 = (Frog)this.frogs.get(n14);
                if ((frog6.state != frogsport.this.STATE_EMERGE || n - frog6.stateStartTime > 5) && this.Colliding(frog6, 0.0f, this.topLeeway, n, true) == frogsport.this.TILE_WALL && frog6.state != frogsport.this.STATE_DEAD) {
                    if ((frog6.state == frogsport.this.STATE_PREP || frog6.state == frogsport.this.STATE_CENS) && frog6.partner.state != frogsport.this.STATE_DEAD) {
                        frog6.partner.state = frogsport.this.STATE_IDLE;
                    }
                    frog6.state = frogsport.this.STATE_DEAD;
                    frog6.stateStartTime = n;
                }
                if (frog6.state == frogsport.this.STATE_DEAD) {
                    frog6.y -= 2.0f;
                }
                ++n14;
            }
            if (!this.goalReached) {
                n14 = 0;
                while (n14 < this.frogs.size()) {
                    Frog frog7 = (Frog)this.frogs.get(n14);
                    if (frog7.state != frogsport.this.STATE_DEAD && frog7.state != frogsport.this.STATE_DROWNED && this.Colliding(frog7, 0.0f, 10.0f, n, true) == frogsport.this.TILE_GOAL) {
                        this.goalReached = true;
                        break;
                    }
                    ++n14;
                }
            }
            n14 = 0;
            while (n14 < this.frogs.size() - 1) {
                Frog frog8 = (Frog)this.frogs.get(n14);
                if (frog8.wantsBaby && (frog8.state == frogsport.this.STATE_WALK || frog8.state == frogsport.this.STATE_IDLE)) {
                    int n15 = n14 + 1;
                    while (n15 < this.frogs.size()) {
                        Frog frog9 = (Frog)this.frogs.get(n15);
                        float f = -9.0f;
                        if (frog8.gender == frogsport.this.GIRL) {
                            f = 9.0f;
                        }
                        if (frog8.flip) {
                            f = -f;
                        }
                        if ((frog9.state == frogsport.this.STATE_WALK || frog9.state == frogsport.this.STATE_IDLE) && frog9.wantsBaby && frog9.gender != frog8.gender && frog8.y == frog9.y && frog8.vy == frog9.vy && frog9.pswap == frog8.pswap && frog9.flip == frog8.flip && this.frogFrogOverlap(frog8, frog9, f, 0.0f, n)) {
                            frog9.stateStartTime = n;
                            frog8.stateStartTime = n;
                            frog8.state = frogsport.this.STATE_PREP;
                            frog9.state = frogsport.this.STATE_PREP;
                            frog9.partner = frog8;
                            frog8.partner = frog9;
                        }
                        ++n15;
                    }
                }
                ++n14;
            }
            ArrayList<Frog> arrayList = new ArrayList<Frog>();
            int n16 = 0;
            while (n16 < this.frogs.size()) {
                frog = (Frog)this.frogs.get(n16);
                if (!(frog.y > (float)frogsport.this.height || frog.state == frogsport.this.STATE_DEAD && frogsport.this.fdata.squish[frog.gender].isDone(n - frog.stateStartTime))) {
                    arrayList.add(frog);
                }
                ++n16;
            }
            this.frogs = arrayList;
        }

        public void Draw(int n) {
            frogsport.this.noStroke();
            int n2 = 0;
            while (n2 < this.tiles.length) {
                int n3 = this.iToX(n2);
                int n4 = this.iToY(n2);
                int n5 = (int)((float)(n3 * this.tile_size_x * this.s) + this.offx);
                int n6 = (int)((float)(n4 * this.tile_size_y * this.s) + this.offy);
                this.SetTileColor(n3, n4, this.tiles[n2] != frogsport.this.TILE_NONE);
                if (this.tiles[n2] == frogsport.this.TILE_GOAL) {
                    frogsport.this.rect(n5, n6, this.tile_size_x * this.s, this.tile_size_y * this.s);
                    frogsport.this.fill(255.0f, 255.0f, 0.0f);
                    frogsport.this.rect(n5 + this.s * 2, n6 + this.s * 3, (this.tile_size_x - 4) * this.s, (this.tile_size_y - 3) * this.s);
                } else if (this.tiles[n2] == frogsport.this.TILE_CIEL) {
                    frogsport.this.rect(n5, n6, this.tile_size_x * this.s, this.s);
                    this.SetTileColor(n3, n4, false);
                    frogsport.this.rect(n5, n6 + this.s, this.tile_size_x * this.s, this.tile_size_y * this.s - this.s);
                } else {
                    frogsport.this.rect(n5, n6, this.tile_size_x * this.s, this.tile_size_y * this.s);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.frogs.size()) {
                ((Frog)this.frogs.get(n2)).Draw(n, this.s);
                ++n2;
            }
            if (this.hasWater) {
                frogsport.this.fill(0.0f, 0.0f, 255.0f, 100.0f);
                float f = this.offy + (float)(this.h * this.tile_size_y * this.s) - (float)this.waterHeight;
                float f2 = this.waterHeight;
                if (f < this.offy - 4.0f) {
                    f = this.offy - 4.0f;
                    f2 = this.h * this.tile_size_y * this.s + 4;
                }
                frogsport.this.rect(this.offx, f, this.w * this.tile_size_x * this.s, f2);
            }
        }
    }

    class Speech {
        CapsFont f;
        PImage[] frame;

        Speech() {
            this.f = new CapsFont("alphabet_small.gif");
            this.frame = new PImage[8];
            this.frame[0] = frogsport.this.managedRequestImage("speech_topleft.gif");
            this.frame[1] = frogsport.this.managedRequestImage("speech_topmid.gif");
            this.frame[2] = frogsport.this.managedRequestImage("speech_topright.gif");
            this.frame[3] = frogsport.this.managedRequestImage("speech_midleft.gif");
            this.frame[4] = frogsport.this.managedRequestImage("speech_midright.gif");
            this.frame[5] = frogsport.this.managedRequestImage("speech_botleft.gif");
            this.frame[6] = frogsport.this.managedRequestImage("speech_botmid.gif");
            this.frame[7] = frogsport.this.managedRequestImage("speech_botright.gif");
        }

        public void DrawFromBotNoF(float f, float f2, String string, int n, int n2) {
            int n3 = 1 + (string.length() - 1) / n2;
            int n4 = string.length();
            if (n3 > 1) {
                n4 = n2;
            }
            if (n4 < 2) {
                n4 = 2;
            }
            boolean bl = true;
            float f3 = (this.frame[0].width + n4 * this.frame[1].width + this.frame[2].width) * n;
            if (f3 + f > 500.0f) {
                bl = false;
            }
            this.DrawFromBotF(f, f2, string, n, n2, bl);
        }

        public void DrawFromBotF(float f, float f2, String string, int n, int n2, boolean bl) {
            int n3 = 1 + (string.length() - 1) / n2;
            int n4 = this.frame[0].height * n + (n3 - 1) * this.frame[3].height * n + this.frame[7].height * n;
            int n5 = 0;
            int n6 = string.length();
            if (n3 > 1) {
                n6 = n2;
            }
            if (n6 < 2) {
                n6 = 2;
            }
            if (!bl) {
                n5 = (n6 * this.frame[1].width + 2) * n;
            }
            this.Draw(f - (float)n5, f2 - (float)n4, string, n, n2, bl);
        }

        public void Draw(float f, float f2, String string, int n, int n2, boolean bl) {
            if (string.length() == 0) {
                string = "  ";
                return;
            }
            if (string.length() == 1) {
                string = String.valueOf(string) + " ";
            }
            int n3 = 1 + (string.length() - 1) / n2;
            int n4 = string.length();
            if (n3 > 1) {
                n4 = n2;
            }
            frogsport.this.image(this.frame[0], f, f2, this.frame[0].width * n, this.frame[0].height * n);
            int n5 = 0;
            while (n5 < n3 - 1) {
                frogsport.this.image(this.frame[3], f, f2 + (float)(this.frame[0].height * n) + (float)(n5 * this.frame[3].height * n), this.frame[3].width * n, this.frame[3].height * n);
                frogsport.this.image(this.frame[4], f + (float)(this.frame[0].width * n) + (float)(this.frame[1].width * n * (n4 - 3)), f2 + (float)(this.frame[0].height * n) + (float)(n5 * this.frame[3].height * n), this.frame[4].width * n, this.frame[4].height * n);
                ++n5;
            }
            n5 = 0;
            while (n5 < n4 - 3) {
                frogsport.this.image(this.frame[1], f + (float)(this.frame[0].width * n) + (float)(this.frame[1].width * n * n5), f2, this.frame[1].width * n, this.frame[1].height * n);
                frogsport.this.image(this.frame[6], f + (float)(this.frame[0].width * n) + (float)(this.frame[1].width * n * n5), f2 + (float)(this.frame[0].height * n) + (float)((n3 - 1) * this.frame[3].height * n), this.frame[6].width * n, this.frame[6].height * n);
                ++n5;
            }
            frogsport.this.image(this.frame[2], f + (float)(this.frame[0].width * n) + (float)(this.frame[1].width * n * (n4 - 3)), f2, this.frame[2].width * n, this.frame[2].height * n);
            if (bl) {
                frogsport.this.imageFlip(this.frame[5], f + (float)(this.frame[0].width * n) + (float)(this.frame[1].width * n * (n4 - 3)), f2 + (float)(this.frame[0].height * n) + (float)((n3 - 1) * this.frame[3].height * n), this.frame[5].width * n, this.frame[5].height * n);
                frogsport.this.imageFlip(this.frame[7], f, f2 + (float)(this.frame[0].height * n) + (float)((n3 - 1) * this.frame[3].height * n), this.frame[7].width * n, this.frame[7].height * n);
            } else {
                frogsport.this.image(this.frame[5], f, f2 + (float)(this.frame[0].height * n) + (float)((n3 - 1) * this.frame[3].height * n), this.frame[5].width * n, this.frame[5].height * n);
                frogsport.this.image(this.frame[7], f + (float)(this.frame[0].width * n) + (float)(this.frame[1].width * n * (n4 - 3)), f2 + (float)(this.frame[0].height * n) + (float)((n3 - 1) * this.frame[3].height * n), this.frame[7].width * n, this.frame[7].height * n);
            }
            frogsport.this.fill(192);
            frogsport.this.stroke(192);
            frogsport.this.rect(f + (float)(this.frame[0].width * n), f2 + (float)(this.frame[0].height * n), (n4 - 3) * this.frame[1].width * n, (n3 - 1) * this.frame[3].height * n);
            n5 = 0;
            while (n5 < n3) {
                this.f.DrawString(f + (float)(5 * n), f2 + (float)(7 * n * n5) + (float)(4 * n), string.substring(n5 * n2, frogsport.min((int)((n5 + 1) * n2), (int)string.length())), n);
                ++n5;
            }
        }
    }
}

