// Class for displaying text in my partial uppercase-only fonts

class CapsFont {
  PImage[] images;
  int w, h;
  PImage bigImage;
  
  boolean inited;
  void init()
  {
    int imageCount = 27;
    images = new PImage[imageCount];
    w = bigImage.width / imageCount;
    h = bigImage.height;
    println("w = " + w + " h = " + h);
    
    for (int i = 0; i < 27; i++)
    {
      images[i] = bigImage.get(w*i,0,w,h);
    }
    inited = true;
  }
  
  CapsFont(String imageFile)
  {
    bigImage = managedRequestImage(imageFile);
    inited = false;
  }
  
  void DrawInt(float xpos, float ypos, int c, int scaling)
  {
    if (!inited)
      init();
    image(images[c], xpos, ypos, w*scaling, h*scaling);
  }
  
  void DrawChar(float xpos, float ypos, char c, int scaling)
  {
    if (c == '?')
      DrawInt(xpos,ypos,26,scaling);
    else {
      int i = int(c);
      if (i > 65+26)
        i -= 32;
      i -= 65;
      if (i >= 0 && i < 26)
        DrawInt(xpos, ypos, i, scaling);
    }
  }
  
  void DrawString(float xpos, float ypos, String words, int scaling)
  {
    int len = words.length();
    for (int i = 0; i < len; i++)
    {
      DrawChar(xpos + i * w * scaling, ypos, words.charAt(i), scaling);
    }
  }
}

