// Displays text using a 3x5 capsfont (how specific!)

class Speech {
  CapsFont f;
  PImage[] frame;
  
   // ugh, we actually need to break this in to corners ...
   // so we can scale horizontally as well as vertically :(
  Speech()
  {
    f = new CapsFont("alphabet_small.gif");
    frame = new PImage[8];
    frame[0] = managedRequestImage("speech_topleft.gif");
    frame[1] = managedRequestImage("speech_topmid.gif");
    frame[2] = managedRequestImage("speech_topright.gif");
    frame[3] = managedRequestImage("speech_midleft.gif");
    frame[4] = managedRequestImage("speech_midright.gif");
    frame[5] = managedRequestImage("speech_botleft.gif");
    frame[6] = managedRequestImage("speech_botmid.gif");
    frame[7] = managedRequestImage("speech_botright.gif");
  }
  
  void DrawFromBotNoF(float xpos, float ypos, String words, int s, int maxline)
  {
    int numlines = 1 + (words.length()-1) / maxline;
    int len = words.length();
    if (numlines > 1)
      len = maxline;
    if (len < 2)
      len = 2;
    
    boolean flip = true;
    float xoff = (frame[0].width+len*frame[1].width+frame[2].width)*s;
    if (xoff + xpos > 500)
    {
      flip = false;
    }
    DrawFromBotF(xpos, ypos, words, s, maxline, flip);
  }
  
  void DrawFromBotF(float xpos, float ypos, String words, int s, int maxline, boolean flip)
  {
    int numlines = 1 + (words.length()-1) / maxline;
    int h = frame[0].height*s+(numlines-1)*frame[3].height*s+frame[7].height*s;
    int xoff = 0;
    
    int len = words.length();
    if (numlines > 1)
      len = maxline;
    if (len < 2)
      len = 2;
    
    if (!flip)
    {
      xoff = (len*frame[1].width+2)*s;
    }
    
    Draw(xpos-xoff, ypos-h,words,s,maxline,flip);
  }
  
  void Draw(float xpos, float ypos, String words, int s, int maxline, boolean flip)
  {
    if (words.length() == 0) {
      words = "  ";
      return;
    }
    if (words.length() == 1)
      words += " ";
    int numlines = 1 + (words.length()-1) / maxline;
    int len = words.length();
    if (numlines > 1)
      len = maxline;
    image(frame[0], xpos, ypos, frame[0].width*s, frame[0].height*s);
    for (int i = 0; i < numlines-1; i++)
    {
//      println("line = " + i + " / " + numlines);
      image(frame[3], xpos, ypos+frame[0].height*s+i*frame[3].height*s, frame[3].width*s, frame[3].height*s);
      image(frame[4], xpos + frame[0].width*s+frame[1].width*s*(len-3),
                    ypos+frame[0].height*s+i*frame[3].height*s, frame[4].width*s, frame[4].height*s);

    }
    
    for (int i = 0; i < len - 3; i++)
    {
      image(frame[1], xpos + frame[0].width*s + frame[1].width*s*i, ypos, frame[1].width*s, frame[1].height*s);
      image(frame[6], xpos + frame[0].width*s + frame[1].width*s*i, 
            ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[6].width*s, frame[6].height*s);
    }
    
    image(frame[2], xpos + frame[0].width*s+frame[1].width*s*(len-3), ypos, frame[2].width*s, frame[2].height*s);
    
    if (flip)
    {
      
      imageFlip(frame[5], xpos + frame[0].width*s+frame[1].width*s*(len-3), 
                    ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[5].width*s, frame[5].height*s);
      imageFlip(frame[7], xpos, ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[7].width*s, frame[7].height*s);
    }
    else
    {
      image(frame[5], xpos, ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[5].width*s, frame[5].height*s);
      image(frame[7], xpos + frame[0].width*s+frame[1].width*s*(len-3), 
                    ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[7].width*s, frame[7].height*s);
    }
    
    fill(192);
    stroke(192);
    rect(xpos+frame[0].width*s, ypos+frame[0].height*s, (len-3)*frame[1].width*s, 
            (numlines-1)*frame[3].height*s);
            
    for (int i = 0; i < numlines; i++)
    {
//      println(i*maxline + ", " + max((i+1)*maxline,len));
      f.DrawString(xpos + 5*s, ypos+7*s*i+4*s, words.substring(i*maxline,min((i+1)*maxline,words.length())), s);
    }
  }
  
}

void imageFlip(PImage i, float xpos, float ypos, float w, float h)
{
  pushMatrix();
  scale(-1,1);
  image(i, -xpos, ypos, -w, h);
  popMatrix();
}

