// Class for animating image/csv pairs that I set graphics gale to export

Animation loadAnimation(String name)
{
  return new Animation(name + ".gif", name + ".csv");
}

boolean g_pswap = false;

class Animation {
  PImage[] images;
  PImage[] palswapped;
  int[] duration;
  int imageCount;
  int totalFrames;
  int w, h;
  boolean inited;
  PImage bigImage;
  String[] lines;
  String csvFile;
  
  Animation(String imageFile, String icsvFile) {
    csvFile = icsvFile;
    lines = loadStrings(csvFile);
    bigImage = managedRequestImage(imageFile);
    inited = false;
  }
  
  void init()
  {
    imageCount = lines.length - 1;
    images = new PImage[imageCount];
    palswapped = new PImage[imageCount];
    duration = new int[imageCount];
    w = bigImage.width;
    h = bigImage.height / imageCount;
    totalFrames = 0;
    
    println(csvFile + " has " + lines.length + " lines");
    for (int i = 1; i < lines.length; i++) {
      String[] pieces = split(lines[i], '"');
      if (pieces.length > 0) {
        duration[i-1] = int(pieces[1]);
        totalFrames += duration[i-1];
        images[i-1] = bigImage.get(0,h*(i-1),w,h);
        palswapped[i-1] = bigImage.get(0,h*(i-1),w,h);
        palswapped[i-1].loadPixels();
        for (int pi = 0; pi < palswapped[i-1].pixels.length; pi++) {
          color c = palswapped[i-1].pixels[pi];
          if (green(c)-red(c)-blue(c) > 129) {
            palswapped[i-1].pixels[pi] = color(red(c),green(c),green(c));
          }
        }
        palswapped[i-1].updatePixels();
      }
    }
    println(csvFile + " totalFrames = " + totalFrames);
    inited = true;
  }
 
  
  int timeToImageNumber(int frame, boolean wrap)
  {
    if (!inited)
      init();
    
    if (!wrap && frame >= totalFrames)
      return imageCount-1;
      
    frame = frame % totalFrames;
    int accum = 0;
    int imNum = 0;
    //println("frame = " + frame);
    while (frame > accum + duration[imNum])
    {
      //println("accum = accum + duration[imNum] = " + accum + " + " + duration[imNum] + " = " + (accum+duration[imNum]));
      accum += duration[imNum];
      imNum++;
    }
    return imNum;
  }
  
  void setTimeScale(int s) {
    timeScale = s;
  }
  
  int timeScale = 2;

  float percent(int time) {
    if (!inited)
      init();
    //println ("totalFrames = " + totalFrames);
    //if (totalFrames == 0)
    //  throw new RuntimeException();
    return min(1,float(time*timeScale) / float(totalFrames));
  }

  boolean isDone(int time) {
    if (!inited)
      init();
    return (time*timeScale >= totalFrames);
  }

  void display(float xpos, float ypos, int frame, boolean wrap, int scaling, boolean flip) {
    if (!inited)
      init();
      
    int imnum = timeToImageNumber(frame*timeScale, wrap); // note: scaled by 2 to make things faster (hack)
    int fs = 1;
    if (flip) {
      pushMatrix();
      scale(-1,1);
      fs = -1;
    }
    if (!g_pswap)
      image(images[imnum], fs*xpos, ypos, fs*w*scaling,h*scaling);
    else
      image(palswapped[imnum], fs*xpos, ypos, fs*w*scaling,h*scaling);
    if (flip)
      popMatrix();
  }
  
  int getWidth() {
  if (!inited)
    init();
      
    return images[0].width;
  }
}

