
class FrogData {
  Animation[] idle, walk, prep, squish, drown;
  Animation baby, emerge;
  PImage censor;
  
  FrogData() {
    idle = new Animation[2];
    idle[0] = loadAnimation("guyidle");
    idle[1] = loadAnimation("girlidle");
    walk = new Animation[2];
    walk[0] = loadAnimation("guywalk");
    walk[1] = loadAnimation("girlwalk");
    prep = new Animation[2];
    prep[0] = loadAnimation("guypre");
    prep[1] = loadAnimation("girlpre");
    squish = new Animation[2];
    squish[0] = loadAnimation("guysquish");
    squish[1] = loadAnimation("girlsquish");
    drown = new Animation[2];
    drown[0] = loadAnimation("guydrown");
    drown[1] = loadAnimation("girldrown");
    emerge = loadAnimation("emerge2");
    emerge.setTimeScale(1);
    baby = loadAnimation("baby");
    censor = managedRequestImage("censor.gif");
  }
}

int BOY = 0;
int GIRL = 1;

int STATE_DROWNED = -2;
int STATE_DEAD = -1;
int STATE_IDLE = 1;
int STATE_WALK = 2;
int STATE_PREP = 3;
int STATE_CENS = 4;
int STATE_BABY = 5;
int STATE_EMERGE = 6;

int CENSOR_TIME = 20;

FrogData fdata;


class FrogXComparator implements java.util.Comparator {
  int o;
  FrogXComparator(int order) {
    o = order;
  }
  
  public int compare(Object o1, Object o2) {
    if (!(o1 instanceof Frog) || !(o2 instanceof Frog)) {
      println("only give me frogs!");
      return 0;
    }
    Frog f1 = (Frog)o1;
    Frog f2 = (Frog)o2;
    if (f1.x*o < f2.x*o)
      return -1;
    if (f1.x*o > f2.x*o)
      return 1;
    if (f1.hashCode() > f2.hashCode())
      return 1;
    if (f1.hashCode() < f2.hashCode())
      return -1;
    return 0;
  }
}

class FrogYComparator implements java.util.Comparator {
  int o;
  int t;
  FrogYComparator(int order, int time) {
    o = order;
    t = time;
  }
  
  public int compare(Object o1, Object o2) {
    if (!(o1 instanceof Frog) || !(o2 instanceof Frog)) {
      println("only give me frogs!");
      return 0;
    }
    Frog f1 = (Frog)o1;
    Frog f2 = (Frog)o2;
    if (f1.dynamicY(t)*o < f2.dynamicY(t)*o)
      return -1;
    if (f1.dynamicY(t)*o > f2.dynamicY(t)*o)
      return 1;
    if (f1.hashCode() > f2.hashCode())
      return 1;
    if (f1.hashCode() < f2.hashCode())
      return -1;
    return 0;
  }
}

class Frog {
  boolean flip;
  float x, y;
  float vx, vy;
  int state;
  int gender;
  boolean wantsBaby;
  int stateStartTime = 0;
  Frog partner;
  Frog baby;
  boolean dead;
  boolean pswap;
  
  Frog(float xp, float yp, int g, boolean pswapp) {
    if (fdata == null) {
      fdata = new FrogData();
    }
    x = xp;
    y = yp;
    gender = g;
    partner = null;
    state = STATE_IDLE;
    flip = true;
    pswap = pswapp;
  }
  
  float dynamicH(int time) {
    if (state != STATE_EMERGE)
      return frogH;
    float percent = fdata.emerge.percent(time-stateStartTime);
    //println(percent + " -> " + frogH + " height becomes " + (frogH*percent));
    return max(3,frogH*percent); // never use a height < 3
  }
  
  float dynamicY(int time) {
    if (state != STATE_EMERGE)
      return y;
    float percent = fdata.emerge.percent(time-stateStartTime);
    //println(percent + " -> " + y + " posn becomes " + (y - (1-percent)*frogH));
    return y + min(frogH-3,(1-percent)*frogH); // never use a height < 3 
  }
  
  void setDynamicY(float gy, int time) {
    if (state != STATE_EMERGE) {
      y = gy;
    } else {
      float percent = fdata.emerge.percent(time-stateStartTime);
      y = gy - min(frogH-3,(1-percent)*frogH);
      float dY = dynamicY(time);
    }
  }
  
  void UpdateStateAndGoals(int time, int s, int activeGender)
  {
    wantsBaby = false; // only set true each frame if user actually presses 'z'
    baby = null; // only set to non-null when we add a new baby (going from STATE_BABY to STATE_IDLE)
    vx = 0;
    
    // the reproducing chain
    if (state == STATE_PREP) { // just move us along through the sequence as the time is right
      if (fdata.prep[gender].isDone(time-stateStartTime)) {
        stateStartTime = time;
        state = STATE_CENS;
      }
    } else if (state == STATE_CENS) {
      if (time - stateStartTime > CENSOR_TIME) {
        stateStartTime = time;
        if (gender == GIRL) {
          state = STATE_BABY;
        } else {
          state = STATE_IDLE;
        }
      }
    } else if (state == STATE_BABY) {
      if (fdata.baby.isDone(time-stateStartTime)) {
        state = STATE_IDLE;
        stateStartTime = time;
        if (gender == GIRL) {
          baby = new Frog(x, y, activeGender, pswap);
          baby.stateStartTime = time;
          baby.flip = flip;
        }
      }
    } else if (state == STATE_EMERGE) {
      if (fdata.emerge.isDone(time-stateStartTime)) {
        state = STATE_IDLE;
        stateStartTime = time;
      }
    }
    
    // idle and walking about
    if (state == STATE_IDLE || state == STATE_WALK) { // determine walking / idle based on key input
      if (keysDown[KEY_RIGHT] || keysDown[KEY_LEFT]) {
        state = STATE_WALK;
        vx = 0;
        if (keysDown[KEY_RIGHT]) {
          vx += 2*s;
          flip = true;
        }
        if (keysDown[KEY_LEFT]) {
          vx -= 2*s;
          flip = false;
        }
      } else {
        state = STATE_IDLE;
      }
      if (keysDown[KEY_Z]) {
        stateStartTime = time; // assuming we don't care about the start time in this mode
        wantsBaby = true;
      }
    }
  }
  
  void Draw(int time, int s) {
    g_pswap = pswap;
    if (state == STATE_IDLE) {
      //println("idle draw: "x + ", " + y + ", " + time);
      fdata.idle[gender].display(x, y-1, time, true, s, flip);
    } else if (state == STATE_WALK) {
      //println("walk");
      fdata.walk[gender].display(x, y-1, time, true, s, flip);
    } else if (state == STATE_PREP) {
      //println("prep");
      if (partner.state != STATE_CENS)
        fdata.prep[gender].display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_CENS) {
      //println("cens");
      //display(PImage im, int xpos, int ypos, int scaling)
      if (gender == GIRL) {
        int xoff = 0;
        if (flip)
          xoff = -frogW;
        display(fdata.censor, (int)x+xoff, (int)y-1, s, false);
      } else {
        if (partner.state != STATE_CENS) {
          fdata.idle[gender].display(x, y-1, time, true, s, flip);
        }
      }
    } else if (state == STATE_BABY) {
      //println("baby");
      fdata.baby.display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_EMERGE) {
      //println("emerge");
      fdata.emerge.display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_DEAD) {
      fdata.squish[gender].display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_DROWNED) {
      fdata.drown[gender].display(x, y-1, time-stateStartTime, false, s, flip);
    }
    g_pswap = false;
  }
  
/*
    Vec2d pos, vel;
    bool goingRight, jumping;
    int state;
    int sub_time;
    int last_kick;
    bool onGround;
    bool grounded;
    int ox, oy;
    int genderToMake;
    Animation walk, idle, sexPrep, baby;
    bool sexables;
    
    bool gender; // false => boy, true => girl
    
    BITMAP *cur;
    
*/
}



