import processing.core.*; 
import processing.xml.*; 

import java.util.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class frogsport extends PApplet {


//import javax.media.opengl.*;
//import processing.opengl.*;

int KEY_LEFT = 0;
int KEY_RIGHT = 1;
int KEY_UP = 2;
int KEY_DOWN = 3;
int KEY_RET = 4;
int KEY_BACKSPACE = 5;
int KEY_SPACE = 6;
int KEY_Z = 7;
int KEY_R = 8;
int KEY_MAX = 9;

int GAME_INTRO = 0;
int GAME_PLAY = 1;
int GAME_BETWEEN = 3;
int GAME_END = 2;


int time;
int gameState = GAME_INTRO;
int stageMenu = -1;

boolean keysDown[];

CapsFont words;

int worldScale = 2;

Dude duder;
Level lev;

public boolean rectOverlap(float ax1, float ay1, float ax2, float ay2,
                    float bx1, float by1, float bx2, float by2) {
  return !(ax2 < bx1 || ax1 > bx2 || ay2 < by1 || ay1 > by2);
}

public void display(PImage im, int xpos, int ypos, int scaling, boolean flip) {
  int fs = 1;
  if (flip) {
    pushMatrix();
    scale(-1,1);
    fs = -1;
  }
  image(im, fs*xpos, ypos, fs*im.width*scaling,im.height*scaling);
  if (flip)
    popMatrix();
}

ArrayList images = new ArrayList();
public PImage managedRequestImage(String file)
{
  PImage req = requestImage(file);
  images.add(req);
  return req;
}

public int requestsSatisfied()
{
  int sat = 0;
  for (int i = 0; i < images.size(); i++)
  {
    PImage img = (PImage)images.get(i);
    if (img.width != 0)
      sat++;
  }
  return sat;
}

float s_offx = 80, s_offy = 70;
int s_tile_size_y = 16, s_tile_size_x = 12, s_s = 2;
String levels[] = {"lev0.txt", "lev1.txt", "lev4.txt",
                  "lev6.txt", "lev3.txt", "lev5.txt","lev9.txt",
                  "lev7.txt", "lev2.txt", "lev8.txt"
                  };
String levelNames[] = /*{"starting out easy", "visible stairs", "make room", 
                      "invisible stairs", "above and below", "a shallow pit", 
                      "frogs cant multitask"}*/
                      {"frogs walk right", "frogs cant jump", "frogs make room", 
                      "frogs cant multitask", "above and below", "a shallow pit","race to the top",
                      "frogs cant swim", "love trumps all", "teamwork"
                      };
boolean completed[];
int curLevel = 0;

PImage realfrog;

public void setup() {
  size(800, 600);
  frameRate(50);
  noSmooth();
  //GL gl = g.beginPGL().gl;
  //gl.glTexParameterf(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST);
  //gl.glTexParameterf(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST);
  //g.endPGL();
  keysDown = new boolean[KEY_MAX];
  for (int i = 0; i < KEY_MAX; i++)
  {
    keysDown[i] = false;
  }
  
  words = new CapsFont("alphabet.gif");
  //duder = new Dude(200,200);
  fdata = new FrogData();
  
  completed = new boolean[levels.length];
  for (int i = 0; i <completed.length; i++) {
    completed[i] = false;
  }
  
  realfrog = managedRequestImage("frogreal.gif");
  
}

boolean slowMode = false;
boolean retPressedLast = false;
boolean spacePressedLast = false;
boolean zPressedLast = false;
boolean arrowsPressedLast = false;
boolean readyToAdvance = false;

public void draw() {
  
  int reqsat = requestsSatisfied();
  if (reqsat < images.size())
  {
    background(0,128,0);
    fill(200,10,10);
    stroke(100,30,30);
    rect(50,200,425 * reqsat / images.size(),20);
    return;
  }
  
  if (gameState == GAME_INTRO) {
    time++;
    background(200,200,0);
    fill(50,100,50);
    if (stageMenu == -1) {
      words.DrawString(30,20,"endless frog kids", 7);
      words.DrawString(150,110,"press z to start", 5);
      for (int i = 0; i < 20; i++) {
        for (int j = 0; j < 7; j ++) {
          fdata.idle[(i+j)%2].display(-2+40*i,150+70*j,time,true,4,true);
        }
      }
    } else {
      background(100,150,50);
      fill(50,100,150);
      stroke(100,30,30);
      words.DrawString(20,20,"select level",10);
      for (int i = 0; i < levels.length; i++) {
        if (i == curLevel) {
          fdata.walk[1].display(20,100+i*7*6,time,true,2,true);
          fill(50,100,150);
          stroke(100,30,30);
          rect(50,100+i*7*6,levelNames[i].length()*5*6,6*6);
          if (completed[i]) {
            words.DrawString(55+levelNames[i].length()*5*6, 100+i*7*6+15,"completed",2);
          }
        } else if (completed[i]) {
          fill(150,150,150);
          stroke(100,100,100);
          rect(50,100+i*7*6,levelNames[i].length()*5*6,6*6);
        }
        words.DrawString(50+3,100+i*7*6+3,levelNames[i],5);
      }
      if ((keysDown[KEY_RIGHT] || keysDown[KEY_DOWN]) && !arrowsPressedLast) {
        curLevel = (curLevel+1)%levels.length;
      }
      if ((keysDown[KEY_LEFT] || keysDown[KEY_UP]) && !arrowsPressedLast) {
        curLevel = (curLevel+levels.length-1)%levels.length;
      }
      arrowsPressedLast = keysDown[KEY_LEFT] || keysDown[KEY_RIGHT] || keysDown[KEY_UP] || keysDown[KEY_DOWN];
    }
    if (keysDown[KEY_Z] && !zPressedLast) {
      if (stageMenu == -1)
        stageMenu = 0;
      
    } else if (readyToAdvance && !keysDown[KEY_Z] && zPressedLast) {
      lev = new Level(levels[curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
      gameState = GAME_PLAY;
      readyToAdvance = false;
    }
    if (stageMenu > -1 && !keysDown[KEY_Z] && !zPressedLast)
      readyToAdvance = true;
    zPressedLast = keysDown[KEY_Z];
    
    return;
  }
  
  if (gameState == GAME_PLAY)
  {
    background(200,200,200);
    fill(50,100,50);
    /*
    if (keysDown[KEY_SPACE] && !spacePressedLast) {
      println("slow mode toggled!");
      slowMode = !slowMode;
    }
    spacePressedLast = keysDown[KEY_SPACE];
    */
    
    if (keysDown[KEY_BACKSPACE])
      gameState = GAME_BETWEEN;
    
    words.DrawString(width / 2 - (levelNames[curLevel].length()*6*5/2), 20, levelNames[curLevel], 5);
    words.DrawString(220,s_offy+s_tile_size_y*s_s*lev.h+100+20,"to play press z and arrows", worldScale);
    words.DrawString(250,s_offy+s_tile_size_y*s_s*lev.h+100+35,"press r to reset level", worldScale);
    words.DrawString(180,s_offy+s_tile_size_y*s_s*lev.h+100+50,"press q to return to level select", worldScale);
    
    words.DrawString(200,s_offy+s_tile_size_y*s_s*lev.h+45,"now producing", 4);
    fdata.idle[lev.activeGender].display(535,s_offy+s_tile_size_y*s_s*lev.h+20,time,true,4,true);
    
    if (keysDown[KEY_R]) {
      lev = new Level(levels[curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
    }
    
    //duder.Draw(time,2);
    if (!slowMode || (keysDown[KEY_RET] && !retPressedLast) || keysDown[KEY_BACKSPACE])
      lev.Update(time);
    lev.Draw(time);
    
    if (lev.goalReached) {
      completed[curLevel] = true;
      boolean allDone = true;
      for (int i = 0; i < completed.length; i++) {
        if (!completed[i]) // if something's not completed go back to men
          allDone = false;
      }
      println("reached goal!");
      if (allDone) {
        gameState = GAME_END;
      }
      else if (curLevel+1 < levels.length) {
        lev = new Level(levels[++curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
        gameState = GAME_BETWEEN;
        zPressedLast = keysDown[KEY_Z];
      } else {
        gameState = GAME_INTRO;
      }
    }
    
    if (!slowMode || (keysDown[KEY_RET] && !retPressedLast) || keysDown[KEY_BACKSPACE])
      time++;
    retPressedLast = keysDown[KEY_RET];
    return;
  } else if (gameState == GAME_END) {
    background(200,200,200);
    fill(50,100,50);
    words.DrawString(50,20,"you win hooray", 5);
    words.DrawString(100,100,"more levels coming soon probably", 1);
    float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "you have won the game", 2);
      words.DrawString(100, ystart+65, "or at least what is done so far", 2);
      words.DrawString(100, ystart+85, "thanks for playing", 2);
      words.DrawString(100, ystart+100,"you heartless global machine", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+110,440,ymid+60);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "h", 3);
      //words.Draw(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "s", 3);
      //words.Draw(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure ten", 2);
      words.DrawString(210, ymid+185, "i have not yet made up a figure", 2);
      words.DrawString(210, ymid+200, "for the last level of the game", 2);
    return;
  } else if (gameState == GAME_BETWEEN) {
    background(50,100,150);
    fill(50,100,50);
    if (keysDown[KEY_Z] && !zPressedLast) {
      gameState = GAME_PLAY;
    }
    zPressedLast = keysDown[KEY_Z];
    words.DrawString(80,50,"level complete", 8);
    words.DrawString(100,110,"for next level press z", 3);
    if (curLevel == 1) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "globalization has quickly replaced traditional", 2);
      words.DrawString(100, ystart+65, "frog culture with a more modern human lifestyle", 2);
      words.DrawString(100, ystart+85, "frogs have abandoned their wild hoppy ways and", 2);
      words.DrawString(100, ystart+100, "now they march in unison with the global machine", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      fdata.idle[0].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(250, ymid+130, "before", 3);
      words.DrawString(400, ymid+130, "after", 3);
      words.DrawString(230, ymid+170, "figure one", 2);
      words.DrawString(230, ymid+185, "effects of globalization", 2);
      words.DrawString(230, ymid+200, "on frog culture", 2);
    } else if (curLevel == 2) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "globalization has pressured female frogs to", 2);
      words.DrawString(100, ystart+65, "submit to the fickle whims of human fashion", 2);
      words.DrawString(100, ystart+85, "they dont know their lipstick was tested on ", 2);
      words.DrawString(100, ystart+100, "captive lab frogs", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(250, ymid+130, "before", 3);
      words.DrawString(400, ymid+130, "after", 3);
      words.DrawString(230, ymid+170, "figure two", 2);
      words.DrawString(230, ymid+185, "effects of globalization", 2);
      words.DrawString(230, ymid+200, "on female frog fashions", 2);
    } else if (curLevel == 3) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-88*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "a sampling of cogs in the global machine confirms", 2);
      words.DrawString(100, ystart+65, "the global machine is heartless", 2);
      words.DrawString(100, ystart+85, "a statistically significant percentage do not worry", 2);
      words.DrawString(100, ystart+100,"when frogs are squished for the greater good", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(400,ymid+110,40,10);
      rect(290,ymid+50,40,70);
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(395, ymid+133, "yes", 3);
      words.DrawString(293, ymid+133, "no", 3);
      words.DrawString(210, ymid+170, "figure three", 2);
      words.DrawString(210, ymid+185, "response to poll question", 2);
      words.DrawString(210, ymid+205, "are you not heartless?", 2);
    } else if (curLevel == 4) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "the mating song is the one refuge of frogs from", 2);
      words.DrawString(100, ystart+65, "the unending demands of the global machine", 2);
      words.DrawString(100, ystart+85, "unfortunately the global machine has learned", 2);
      words.DrawString(100, ystart+100,"to reproduce this mating song artificially", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(400,ymid+110,40,10);
      rect(290,ymid+50,40,70);
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(395, ymid+133, "sex", 3);
      words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure four", 2);
      words.DrawString(210, ymid+200, "frog responsiveness", 2);
      words.DrawString(210, ymid+185, "effects of mating on", 2);
    } else if (curLevel == 5) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "the societal status of a male frog is equal", 2);
      words.DrawString(100, ystart+65, "to the height from which it was born", 2);
      words.DrawString(100, ystart+85, "the only use of a male frog beneath you", 2);
      words.DrawString(100, ystart+100,"is to step on its head", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+110,440,ymid+60);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "h", 3);
      //words.DrawString(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "s", 3);
      //words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure five", 2);
      words.DrawString(210, ymid+185, "male frog social status s versus", 2);
      words.DrawString(210, ymid+200, "initial height h in level", 2);
    } else if (curLevel == 6) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "the endless fertility of frogs is great", 2);
      words.DrawString(100, ystart+65, "for filling pot holes", 2);
      words.DrawString(100, ystart+85, "to the global machine frogs may as well be", 2);
      words.DrawString(100, ystart+100,"some new form of pavement", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(400,ymid+110,40,10);
      rect(275,ymid+50,40,70);
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(365, ymid+133, "asphalt", 3);
      words.DrawString(250, ymid+133, "frogs", 3);
      words.DrawString(210, ymid+170, "figure six", 2);
      words.DrawString(210, ymid+185, "cost effectiveness of frogs", 2);
      words.DrawString(210, ymid+200, "compared to asphalt", 2);
    } else if (curLevel == 7) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "at current exponential growth rates frogs", 2);
      words.DrawString(100, ystart+65, "will soon be the majority species on earth ", 2);
      words.DrawString(100, ystart+85, "shortly thereafter they will outnumber", 2);
      words.DrawString(100, ystart+100, "the atoms in the universe", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+60,302,ymid+110);
      line(302,ymid+110,450,ymid+110);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "s", 3);
      //words.DrawString(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "t", 3);
      //words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure eight", 2);
      words.DrawString(210, ymid+185, "space in universe not occupied by frogs s", 2);
      words.DrawString(210, ymid+200, "plotted against time t", 2);
    } else if (curLevel == 8) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "before globalization frogs had a rich swimming", 2);
      words.DrawString(100, ystart+65, "tradition and were some of the worlds ", 2);
      words.DrawString(100, ystart+80, "best known amphibians", 2);
      words.DrawString(100, ystart+100, "now they can hardly hold their breath", 2);
      words.DrawString(100, ystart+115,"for even a few seconds underwater", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+60,440,ymid+110);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "s", 3);
      //words.DrawString(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "g", 3);
      //words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure eight", 2);
      words.DrawString(210, ymid+185, "frog swimming ability s with respect to", 2);
      words.DrawString(210, ymid+200, "level of globalization g", 2);
    } else if (curLevel == 9) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+65, "frogs are an excellent new organic material", 2);
      words.DrawString(100, ystart+80, "for building bridges ", 2);
      float ww = frogW*3/2-5;
      float hh = frogH*3/2-1;
      float xbase = 280;
      fill(200,200,0);
      stroke(0,0,0);
      rect(245,ymid+10,190,155);
      fdata.idle[0].display( xbase, ymid+110, 0, false, 3, true);
      fdata.idle[1].display( xbase+ww, ymid+110-hh, 0, false, 3, true);
      fdata.idle[0].display( xbase+2*ww, ymid+110-hh*2, 0, false, 3, true);
      fdata.idle[1].display( xbase+3*ww, ymid+110-hh, 0, false, 3, false);
      fdata.idle[0].display( xbase+4*ww, ymid+110, 0, false, 3, false);
      words.DrawString(210, ymid+173, "figure nine", 2);
      words.DrawString(210, ymid+188, "spiky bridge is made of frogs", 2);
      
    }
    return;
  }
  
  // the basic layout 
  background(128,0,0);
  fill(0);
  stroke(0);
  //rect(11,11,frame.width*3-2, frame.height*3-2);

  time++;
}


boolean failedPress = false;


public void keyPressed()
{
  // todo, remove level skip hack
  int keynum = key - '0';
  if (keynum >= 0 && keynum <= 6) {
    curLevel = keynum;
    lev = new Level(levels[curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
  }
  
  if (key == ESC) { // map esc to 'q' to avoid the automatic handling (which quits the program, nonsense for applets ...)
    key = 'q';
  }
  
  if (key == 'q' || key == 'Q') {
    gameState = GAME_INTRO;
  }
  
  if (key == RETURN || key == ENTER)
    keysDown[KEY_RET] = true;
  if (key == BACKSPACE)
    keysDown[KEY_BACKSPACE] = true;
  if (key == ' ')
    keysDown[KEY_SPACE] = true;
  if (key == 'Z' || key == 'z')
    keysDown[KEY_Z] = true;
  if (key == 'R' || key == 'r')
    keysDown[KEY_R] = true;
  
  if (key == CODED) // coded keys are just character movement
  {
    if (keyCode == LEFT)
      keysDown[KEY_LEFT] = true;
    if (keyCode == RIGHT)
      keysDown[KEY_RIGHT] = true;
    if (keyCode == UP)
      keysDown[KEY_UP] = true;
    if (keyCode == DOWN)
      keysDown[KEY_DOWN] = true;
  }

}

public void keyReleased()
{
  if (key == RETURN || key == ENTER)
    keysDown[KEY_RET] = false;
  if (key == BACKSPACE)
    keysDown[KEY_BACKSPACE] = false;
  if (key == ' ')
    keysDown[KEY_SPACE] = false;
  if (key == 'Z' || key == 'z')
    keysDown[KEY_Z] = false;
  if (key == 'R' || key == 'r')
    keysDown[KEY_R] = false;
    
  if (key == CODED) // coded keys are just character movement
  {
    if (keyCode == LEFT)
      keysDown[KEY_LEFT] = false;
    if (keyCode == RIGHT)
      keysDown[KEY_RIGHT] = false;
    if (keyCode == UP)
      keysDown[KEY_UP] = false;
    if (keyCode == DOWN)
      keysDown[KEY_DOWN] = false;
  }
  
}

// Class for animating image/csv pairs that I set graphics gale to export

public Animation loadAnimation(String name)
{
  return new Animation(name + ".gif", name + ".csv");
}

boolean g_pswap = false;

class Animation {
  PImage[] images;
  PImage[] palswapped;
  int[] duration;
  int imageCount;
  int totalFrames;
  int w, h;
  boolean inited;
  PImage bigImage;
  String[] lines;
  String csvFile;
  
  Animation(String imageFile, String icsvFile) {
    csvFile = icsvFile;
    lines = loadStrings(csvFile);
    bigImage = managedRequestImage(imageFile);
    inited = false;
  }
  
  public void init()
  {
    imageCount = lines.length - 1;
    images = new PImage[imageCount];
    palswapped = new PImage[imageCount];
    duration = new int[imageCount];
    w = bigImage.width;
    h = bigImage.height / imageCount;
    totalFrames = 0;
    
    println(csvFile + " has " + lines.length + " lines");
    for (int i = 1; i < lines.length; i++) {
      String[] pieces = split(lines[i], '"');
      if (pieces.length > 0) {
        duration[i-1] = PApplet.parseInt(pieces[1]);
        totalFrames += duration[i-1];
        images[i-1] = bigImage.get(0,h*(i-1),w,h);
        palswapped[i-1] = bigImage.get(0,h*(i-1),w,h);
        palswapped[i-1].loadPixels();
        for (int pi = 0; pi < palswapped[i-1].pixels.length; pi++) {
          int c = palswapped[i-1].pixels[pi];
          if (green(c)-red(c)-blue(c) > 129) {
            palswapped[i-1].pixels[pi] = color(red(c),green(c),green(c));
          }
        }
        palswapped[i-1].updatePixels();
      }
    }
    println(csvFile + " totalFrames = " + totalFrames);
    inited = true;
  }
 
  
  public int timeToImageNumber(int frame, boolean wrap)
  {
    if (!inited)
      init();
    
    if (!wrap && frame >= totalFrames)
      return imageCount-1;
      
    frame = frame % totalFrames;
    int accum = 0;
    int imNum = 0;
    //println("frame = " + frame);
    while (frame > accum + duration[imNum])
    {
      //println("accum = accum + duration[imNum] = " + accum + " + " + duration[imNum] + " = " + (accum+duration[imNum]));
      accum += duration[imNum];
      imNum++;
    }
    return imNum;
  }
  
  public void setTimeScale(int s) {
    timeScale = s;
  }
  
  int timeScale = 2;

  public float percent(int time) {
    if (!inited)
      init();
    //println ("totalFrames = " + totalFrames);
    //if (totalFrames == 0)
    //  throw new RuntimeException();
    return min(1,PApplet.parseFloat(time*timeScale) / PApplet.parseFloat(totalFrames));
  }

  public boolean isDone(int time) {
    if (!inited)
      init();
    return (time*timeScale >= totalFrames);
  }

  public void display(float xpos, float ypos, int frame, boolean wrap, int scaling, boolean flip) {
    if (!inited)
      init();
      
    int imnum = timeToImageNumber(frame*timeScale, wrap); // note: scaled by 2 to make things faster (hack)
    int fs = 1;
    if (flip) {
      pushMatrix();
      scale(-1,1);
      fs = -1;
    }
    if (!g_pswap)
      image(images[imnum], fs*xpos, ypos, fs*w*scaling,h*scaling);
    else
      image(palswapped[imnum], fs*xpos, ypos, fs*w*scaling,h*scaling);
    if (flip)
      popMatrix();
  }
  
  public int getWidth() {
  if (!inited)
    init();
      
    return images[0].width;
  }
}

// Class for displaying text in my partial uppercase-only fonts

class CapsFont {
  PImage[] images;
  int w, h;
  PImage bigImage;
  
  boolean inited;
  public void init()
  {
    int imageCount = 27;
    images = new PImage[imageCount];
    w = bigImage.width / imageCount;
    h = bigImage.height;
    println("w = " + w + " h = " + h);
    
    for (int i = 0; i < 27; i++)
    {
      images[i] = bigImage.get(w*i,0,w,h);
    }
    inited = true;
  }
  
  CapsFont(String imageFile)
  {
    bigImage = managedRequestImage(imageFile);
    inited = false;
  }
  
  public void DrawInt(float xpos, float ypos, int c, int scaling)
  {
    if (!inited)
      init();
    image(images[c], xpos, ypos, w*scaling, h*scaling);
  }
  
  public void DrawChar(float xpos, float ypos, char c, int scaling)
  {
    if (c == '?')
      DrawInt(xpos,ypos,26,scaling);
    else {
      int i = PApplet.parseInt(c);
      if (i > 65+26)
        i -= 32;
      i -= 65;
      if (i >= 0 && i < 26)
        DrawInt(xpos, ypos, i, scaling);
    }
  }
  
  public void DrawString(float xpos, float ypos, String words, int scaling)
  {
    int len = words.length();
    for (int i = 0; i < len; i++)
    {
      DrawChar(xpos + i * w * scaling, ypos, words.charAt(i), scaling);
    }
  }
}

// class for the dude I control

int FSTATE_MOVE = 0;
int FSTATE_TALK = 1;
int FSTATE_IDLE = 2;

class Dude {
  float xpos, ypos;
  boolean flip;
  Animation move, idle, talk;
  int state;
  
  Dude(float x, float y)
  {
    xpos = x; ypos = y;
    move = loadAnimation("guywalk");
    idle = loadAnimation("guyidle");
    talk = loadAnimation("emerge2");
    state = FSTATE_IDLE;
    flip = true;
  }
  
  public void Update() // separate from draw?
  {
  }
  
  
  int wallhit = 0;
  public void WallHit(int dir)
  {
    wallhit = dir;
  }
  
  public void DrawNoInput(int time, int s)
  {
    if (state == FSTATE_MOVE)
    {
      move.display(xpos, ypos, time, true, s, flip);
    }
    if (state == FSTATE_IDLE)
    {
      idle.display(xpos,ypos,time,true,s,flip);
    }
    if (state == FSTATE_TALK)
    {
      talk.display(xpos,ypos,time,true,s,flip);
    }
  }
  
  public void Draw(int time, int s)
  {
    if (keysDown[KEY_RIGHT] || keysDown[KEY_LEFT])
    {
      state = FSTATE_MOVE;
      boolean moved = false;
      if (wallhit != -1 && keysDown[KEY_LEFT]) {
        flip = false;
        xpos -= 1*s;
        moved = true;
      }
      if (wallhit != 1 && keysDown[KEY_RIGHT]) {
        flip = true;
        xpos += 1*s;
        moved = true;
      }
      if (moved)
        move.display(xpos, ypos, time, true, s, flip);
      else
        state = FSTATE_IDLE;
    }
    else
    {
      if (state == FSTATE_MOVE)
        state = FSTATE_IDLE;
    }
    
    if (state == FSTATE_IDLE)
    {
      idle.display(xpos,ypos,time,true,s,flip);
    }
    if (state == FSTATE_TALK)
    {
      talk.display(xpos,ypos,time,true,s,flip);
    }
    
    wallhit = 0;
  }
}



class FrogData {
  Animation[] idle, walk, prep, squish, drown;
  Animation baby, emerge;
  PImage censor;
  
  FrogData() {
    idle = new Animation[2];
    idle[0] = loadAnimation("guyidle");
    idle[1] = loadAnimation("girlidle");
    walk = new Animation[2];
    walk[0] = loadAnimation("guywalk");
    walk[1] = loadAnimation("girlwalk");
    prep = new Animation[2];
    prep[0] = loadAnimation("guypre");
    prep[1] = loadAnimation("girlpre");
    squish = new Animation[2];
    squish[0] = loadAnimation("guysquish");
    squish[1] = loadAnimation("girlsquish");
    drown = new Animation[2];
    drown[0] = loadAnimation("guydrown");
    drown[1] = loadAnimation("girldrown");
    emerge = loadAnimation("emerge2");
    emerge.setTimeScale(1);
    baby = loadAnimation("baby");
    censor = managedRequestImage("censor.gif");
  }
}

int BOY = 0;
int GIRL = 1;

int STATE_DROWNED = -2;
int STATE_DEAD = -1;
int STATE_IDLE = 1;
int STATE_WALK = 2;
int STATE_PREP = 3;
int STATE_CENS = 4;
int STATE_BABY = 5;
int STATE_EMERGE = 6;

int CENSOR_TIME = 20;

FrogData fdata;


class FrogXComparator implements java.util.Comparator {
  int o;
  FrogXComparator(int order) {
    o = order;
  }
  
  public int compare(Object o1, Object o2) {
    if (!(o1 instanceof Frog) || !(o2 instanceof Frog)) {
      println("only give me frogs!");
      return 0;
    }
    Frog f1 = (Frog)o1;
    Frog f2 = (Frog)o2;
    if (f1.x*o < f2.x*o)
      return -1;
    if (f1.x*o > f2.x*o)
      return 1;
    if (f1.hashCode() > f2.hashCode())
      return 1;
    if (f1.hashCode() < f2.hashCode())
      return -1;
    return 0;
  }
}

class FrogYComparator implements java.util.Comparator {
  int o;
  int t;
  FrogYComparator(int order, int time) {
    o = order;
    t = time;
  }
  
  public int compare(Object o1, Object o2) {
    if (!(o1 instanceof Frog) || !(o2 instanceof Frog)) {
      println("only give me frogs!");
      return 0;
    }
    Frog f1 = (Frog)o1;
    Frog f2 = (Frog)o2;
    if (f1.dynamicY(t)*o < f2.dynamicY(t)*o)
      return -1;
    if (f1.dynamicY(t)*o > f2.dynamicY(t)*o)
      return 1;
    if (f1.hashCode() > f2.hashCode())
      return 1;
    if (f1.hashCode() < f2.hashCode())
      return -1;
    return 0;
  }
}

class Frog {
  boolean flip;
  float x, y;
  float vx, vy;
  int state;
  int gender;
  boolean wantsBaby;
  int stateStartTime = 0;
  Frog partner;
  Frog baby;
  boolean dead;
  boolean pswap;
  
  Frog(float xp, float yp, int g, boolean pswapp) {
    if (fdata == null) {
      fdata = new FrogData();
    }
    x = xp;
    y = yp;
    gender = g;
    partner = null;
    state = STATE_IDLE;
    flip = true;
    pswap = pswapp;
  }
  
  public float dynamicH(int time) {
    if (state != STATE_EMERGE)
      return frogH;
    float percent = fdata.emerge.percent(time-stateStartTime);
    //println(percent + " -> " + frogH + " height becomes " + (frogH*percent));
    return max(3,frogH*percent); // never use a height < 3
  }
  
  public float dynamicY(int time) {
    if (state != STATE_EMERGE)
      return y;
    float percent = fdata.emerge.percent(time-stateStartTime);
    //println(percent + " -> " + y + " posn becomes " + (y - (1-percent)*frogH));
    return y + min(frogH-3,(1-percent)*frogH); // never use a height < 3 
  }
  
  public void setDynamicY(float gy, int time) {
    if (state != STATE_EMERGE) {
      y = gy;
    } else {
      float percent = fdata.emerge.percent(time-stateStartTime);
      y = gy - min(frogH-3,(1-percent)*frogH);
      float dY = dynamicY(time);
    }
  }
  
  public void UpdateStateAndGoals(int time, int s, int activeGender)
  {
    wantsBaby = false; // only set true each frame if user actually presses 'z'
    baby = null; // only set to non-null when we add a new baby (going from STATE_BABY to STATE_IDLE)
    vx = 0;
    
    // the reproducing chain
    if (state == STATE_PREP) { // just move us along through the sequence as the time is right
      if (fdata.prep[gender].isDone(time-stateStartTime)) {
        stateStartTime = time;
        state = STATE_CENS;
      }
    } else if (state == STATE_CENS) {
      if (time - stateStartTime > CENSOR_TIME) {
        stateStartTime = time;
        if (gender == GIRL) {
          state = STATE_BABY;
        } else {
          state = STATE_IDLE;
        }
      }
    } else if (state == STATE_BABY) {
      if (fdata.baby.isDone(time-stateStartTime)) {
        state = STATE_IDLE;
        stateStartTime = time;
        if (gender == GIRL) {
          baby = new Frog(x, y, activeGender, pswap);
          baby.stateStartTime = time;
          baby.flip = flip;
        }
      }
    } else if (state == STATE_EMERGE) {
      if (fdata.emerge.isDone(time-stateStartTime)) {
        state = STATE_IDLE;
        stateStartTime = time;
      }
    }
    
    // idle and walking about
    if (state == STATE_IDLE || state == STATE_WALK) { // determine walking / idle based on key input
      if (keysDown[KEY_RIGHT] || keysDown[KEY_LEFT]) {
        state = STATE_WALK;
        vx = 0;
        if (keysDown[KEY_RIGHT]) {
          vx += 2*s;
          flip = true;
        }
        if (keysDown[KEY_LEFT]) {
          vx -= 2*s;
          flip = false;
        }
      } else {
        state = STATE_IDLE;
      }
      if (keysDown[KEY_Z]) {
        stateStartTime = time; // assuming we don't care about the start time in this mode
        wantsBaby = true;
      }
    }
  }
  
  public void Draw(int time, int s) {
    g_pswap = pswap;
    if (state == STATE_IDLE) {
      //println("idle draw: "x + ", " + y + ", " + time);
      fdata.idle[gender].display(x, y-1, time, true, s, flip);
    } else if (state == STATE_WALK) {
      //println("walk");
      fdata.walk[gender].display(x, y-1, time, true, s, flip);
    } else if (state == STATE_PREP) {
      //println("prep");
      if (partner.state != STATE_CENS)
        fdata.prep[gender].display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_CENS) {
      //println("cens");
      //display(PImage im, int xpos, int ypos, int scaling)
      if (gender == GIRL) {
        int xoff = 0;
        if (flip)
          xoff = -frogW;
        display(fdata.censor, (int)x+xoff, (int)y-1, s, false);
      } else {
        if (partner.state != STATE_CENS) {
          fdata.idle[gender].display(x, y-1, time, true, s, flip);
        }
      }
    } else if (state == STATE_BABY) {
      //println("baby");
      fdata.baby.display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_EMERGE) {
      //println("emerge");
      fdata.emerge.display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_DEAD) {
      fdata.squish[gender].display(x, y-1, time-stateStartTime, false, s, flip);
    } else if (state == STATE_DROWNED) {
      fdata.drown[gender].display(x, y-1, time-stateStartTime, false, s, flip);
    }
    g_pswap = false;
  }
  
/*
    Vec2d pos, vel;
    bool goingRight, jumping;
    int state;
    int sub_time;
    int last_kick;
    bool onGround;
    bool grounded;
    int ox, oy;
    int genderToMake;
    Animation walk, idle, sexPrep, baby;
    bool sexables;
    
    bool gender; // false => boy, true => girl
    
    BITMAP *cur;
    
*/
}





int TILE_NONE = 0;
int TILE_WALL = 2;
int TILE_CIEL = 1;
int TILE_GOAL = -1;
int TILE_FROG = 3;

int frogW = 17, frogH = 32;
//int frogW = 10, frogH = 16;

class Level
{
  int w, h;
  int[] tiles;
  ArrayList frogs;
  boolean goalReached;
  int activeGender;
  boolean hasWater;
  int waterHeight;
  int timeStart;
  
  public int xyToI(int x, int y)
  {
    return y*w + x;
  }
  public int iToX(int i)
  {
    return i % w;
  }
  public int iToY(int i)
  {
    return i / w;
  }
  
  float offx, offy;
  int tile_size_x;
  int tile_size_y;
  int s;
  
  int topLeeway = 10;
  
  Level(String mapFile, float ox, float oy, int t_s_x, int t_s_y, int _scale, int time) {
    timeStart = time;
    hasWater = false;
    waterHeight = 20;
    offx = ox;
    offy = oy;
    tile_size_x = t_s_x;
    tile_size_y = t_s_y;
    s = _scale;
    activeGender = 0;
    loadMap(mapFile);
    goalReached = false;
  }
  
  /*int Colliding(float xd, float yd, int cw, int ch)
  {
    if (yd < offy+1)
      yd = offy+1;
    int x = (int)xd, y = (int)yd;
    int xa = (int)((x - offx) / (tile_size*s));
    int ya = (int)((y - offy) / (tile_size*s));
    int i = xyToI(xa,ya);
    if (xa < 0 || ya < 0 || xa >= w || ya >= h || i < 0 || i >= tiles.length) {
      return TILE_WALL;
    } else {
      return tiles[i];
    }
  }*/
  
  public boolean frogFrogOverlap(Frog f, Frog g, float xshift, float yshift, int time) {
    if (f.state == STATE_DEAD || g.state == STATE_DEAD)
      return false;
    float fy = f.dynamicY(time);
    float gy = g.dynamicY(time);
    return rectOverlap(f.x+xshift, fy, f.x+xshift+frogW, fy+f.dynamicH(time)+yshift-1, 
                       g.x, gy, g.x+frogW, gy+g.dynamicH(time)-1);
    //if (f.state == STATE_EMERGE) {
    //return (abs(g.x-f.x-xshift) < frogW && abs(g.y-f.y) < frogH);
  }
  
  public boolean frogFrogColliding(Frog f, float xshift, float yshift, int time) {
    for (int i = 0; i < frogs.size(); i++) {
      Frog g = (Frog)frogs.get(i);
      if (g == f)
        continue;
      if ((g.state != STATE_EMERGE || time-g.stateStartTime>5) && Colliding(g, 0, 0, time, true) == TILE_WALL)
        continue; // g is stuck in a wall, so ignore it
      if (frogFrogOverlap(f,g,xshift,yshift,time))
        return true;
    }
    return false;
  }
  
  // frog f == the frog you are currently. 
  public int Colliding(Frog f, float xshift, float yshift, int time, boolean justCheckTilesTops)
  {
      int cw = frogW, ch = frogH; 
      if (justCheckTilesTops)
        ch = 1;
      float xd = f.x+xshift, yd = f.dynamicY(time)+yshift;
      //if (yd < offy+1)
       // yd = offy+1;
      int x = (int)xd, y = (int)yd;
      //println(cw + ", " + tile_size*s);
      int toRet = TILE_NONE; // 0 for not colliding
      for (int xi = x; xi <= x + cw + tile_size_x*s; xi += tile_size_x*s-1)
      {
          int xt = xi;
          if (xi > x+cw) // make sure we get the endpoints
          {
            //println("at max x");
              xt = x+cw;
          }
          
          int xa = (int)((xt - offx) / (tile_size_x*s));
          if (xt < offx)
              return TILE_WALL;
              
          //println(xi + " ... " + xt + " => " + xa + " [ " + (x + cw + tile_size*s) + " + " + (tile_size*s-1));
 
          for (int yi = y+topLeeway; yi <= y + ch + tile_size_y*s; yi += tile_size_y*s-1)
          {
              int yt = yi;
              if (yi >= y+ch)
              {
                  yt = y+ch-1;
              }
              if (yt < offy) {
                  //println("oh no too high up how can this be");
                  return TILE_WALL;
              }
              int yatop = (int)((y-offy)/(tile_size_y*s));
              int yabot = (int)((y+ch-1-offy)/(tile_size_y*s));
              int ya = (int)((yt - offy) / (tile_size_y*s));
              int i = xyToI(xa, ya);
              //println("testing " + xa + ", " + ya + ", " + w);
              //cout << xa << ", " << ya << " | ";
              if (ya >= h) // we will always fall through the bottom ...
                return TILE_NONE;
                
              if (xa < 0 || ya < 0 || xa >= w || ya >= h || i < 0 || i >= tiles.length) {
              //    cout << xa << "% " << ya << endl;
               // println("returning wall");
                return TILE_WALL;
              } else if (tiles[i] != TILE_NONE) {
                if (tiles[i] == TILE_WALL) {
                 // println("returning wall2");
                  return TILE_WALL;
                } else {
                  //println("toRet = " + toRet);
                  if (tiles[i] == TILE_CIEL) {
                    if (ya == yabot && yabot!=yatop) // only if we're spanning multiple and this is the bot
                      toRet = TILE_CIEL;
                  }
                  else
                    toRet = tiles[i];
                }
              }
          }
          //println("mbjhhjkf " + xi + " ... " + xt + " => " + xa + " [ " + (x + cw + tile_size*s) + " + " + (tile_size*s-1));
          //println((xi + tile_size*s+1 <= (x + cw + tile_size*s)));
      }
      
      if (justCheckTilesTops) // early out for just checking against the tile map
        return toRet;
      
      if (frogFrogColliding(f, xshift, yshift, time))
        return TILE_FROG;
      //cout << endl;
      //cout << endl;
      return toRet;
  }
  
  public void loadMap(String mapFile) {
    frogs = new ArrayList();
    
    String[] lines = loadStrings(mapFile);
    String[] pieces = split(lines[0], ' ');
    if (pieces.length < 2) {
      println("failed to read map; expected dimensions on first line");
      return;
    }
    w = PApplet.parseInt(pieces[0]);
    h = PApplet.parseInt(pieces[1]);
    
    offx = (width - w * tile_size_x * s)/2;
    char gender = pieces[2].charAt(0);
    if (gender == 'F' || gender == 'W')
      activeGender = GIRL;
    else
      activeGender = BOY;
    if (pieces.length >= 4 && pieces[3].length() > 0 && pieces[3].charAt(0) == 'W')
      hasWater = true;
    tiles = new int[w*h];
    for (int i = 1; i < 1+h; i++) {
      pieces = split(lines[i], ' ');
      if (pieces.length == 0) {
        println("empty line where row of map expected");
        return;
      }
      if (pieces[0].length() != w) {
        println("row of incorrect length");
        return;
      }
      for (int j = 0; j < pieces[0].length(); j++) {
        if ('M'==pieces[0].charAt(j)) {
          println(offx + ", " + offy);
          println("pos = " + (j * tile_size_x*s + offx) + ", " + (i * tile_size_y*s + offy));
          frogs.add(new Frog(j * tile_size_x*s + offx, (i-1) * tile_size_y*s + offy,BOY,false));
        } else if ('N'==pieces[0].charAt(j)) {
          frogs.add(new Frog(j * tile_size_x*s + offx, (i-1) * tile_size_y*s + offy,BOY,true));
        } else if ('Q'==pieces[0].charAt(j)) {
          frogs.add(new Frog(j * tile_size_x*s + offx, (i-1) * tile_size_y*s + offy,GIRL,true));
        } else if ('W'==pieces[0].charAt(j)) {
          frogs.add(new Frog(j * tile_size_x*s + offx, (i-1) * tile_size_y*s + offy,GIRL,false));
        } else if ('J'==pieces[0].charAt(j)) {
          tiles[xyToI(j,i-1)] = TILE_WALL;
        } else if ('^'==pieces[0].charAt(j)) {
          tiles[xyToI(j,i-1)] = TILE_CIEL;
        } else if ('G'==pieces[0].charAt(j)) {
          tiles[xyToI(j,i-1)] = TILE_GOAL;
        } else {
          tiles[xyToI(j,i-1)] = TILE_NONE;
        }
      }
    }
  }
  
  public void SetTileColor(int x, int y, boolean filled) {
    if ((x + y) % 2 == 0)
    {
        if (filled)
            fill(83,83,0);
        else
            fill(133,250,183);
    }
    else
    {
        if (filled)
            fill(0,64,64);
        else
            fill(0,255,128);
    }
  }
  

  
  public void Update(int time) {
    waterHeight = (time-timeStart) / 4;
    
    if (hasWater) {
      for (int i = 0; i < frogs.size(); i++) {
        if (((Frog)frogs.get(i)).y > offy+h*tile_size_y*s-waterHeight && ((Frog)frogs.get(i)).state != STATE_DROWNED) {
          ((Frog)frogs.get(i)).state = STATE_DROWNED;
          ((Frog)frogs.get(i)).stateStartTime = time;
        }
      }
    }
    
    for (int i = 0; i < frogs.size(); i++) {
      ((Frog)frogs.get(i)).UpdateStateAndGoals(time,s,activeGender);
    }

    int o = 1;
    if (keysDown[KEY_LEFT])
      o = -1;
    TreeSet frogsortx = new TreeSet(new FrogXComparator(o));
    TreeSet frogsorty;
    for (int i = 0; i < frogs.size(); i++) {
      frogsortx.add(frogs.get(i));
    }
    
    
    // move horizontally
    Iterator fxit = frogsortx.iterator();
    while (fxit.hasNext()) { 
      Frog f = (Frog)fxit.next();
      float toMove = 0;
      int sign = 1;
      if (f.vx < 0)
        sign = -1;
      float lastGood = toMove;
      while (sign*toMove < sign*f.vx && Colliding(f, toMove+sign*4, 0, time, false) < TILE_WALL) { 
        lastGood = toMove;
        toMove += sign;
      }
      f.x+=lastGood;
    }
    
    

    
    

    // spawn frogs
    int previousSize = frogs.size();
    for (int i = 0; i < previousSize; i++) {
      Frog f = (Frog)frogs.get(i);
      if (f.baby != null) {
        frogs.add(f.baby);
        f.baby.state = STATE_EMERGE;
        f.baby.stateStartTime = time;
        f.y -= 2;
        f.baby = null;
      }
    }
    
    // move vertically (due to emerging)
    //println("starting vertical moves");
    frogsorty = new TreeSet(new FrogYComparator(-1,time));
    for (int i = 0; i < frogs.size(); i++) {
      frogsorty.add(frogs.get(i));
    }
    Iterator fyit = frogsorty.iterator();
    while (fyit.hasNext()) {
      Frog f = (Frog)fyit.next();
      if (f.state == STATE_DEAD)
        continue;
      //if ((f.state != STATE_EMERGE || time-f.stateStartTime>5) && Colliding(f, 0, 10, time, true) == TILE_WALL)
        //  continue; // f is stuck in a wall, so ignore it
      //println("processing frog with state = " + f.
      for (int i = 0; i < frogs.size(); i++) {
        Frog g = (Frog)frogs.get(i);
        if (f == g || g.state == STATE_DEAD)
          continue;
        //if ((g.state != STATE_EMERGE || time-g.stateStartTime>5) && Colliding(g, 0, 5, time, true) == TILE_WALL)
          //continue; // g is stuck in a wall, so ignore it
        if (frogFrogOverlap(f, g, 0, 0, time)) {
          //println("g.state = " + g.state + " ; f.state = " + f.state);
          //println("before: g.y = " + g.y + "; f.y = " + f.dynamicY(time) + "; g.dynamicH = " + g.dynamicH(time));
          g.setDynamicY(f.dynamicY(time) - g.dynamicH(time) - 1, time);
          if (g.state == STATE_PREP || g.state == STATE_CENS) {
            g.partner.y = g.y;
          }
          //println("after: g.y = " + g.y);
          //g.y -= 8;
        }
      }
    } // done moving vertically
    
    
    // move vertically (more specifically: y accel due to gravity goes here)
    //for (int iters = 0; iters < 2; iters++) {
   
    frogsorty = new TreeSet(new FrogYComparator(-1,time));
    for (int i = 0; i < frogs.size(); i++) {
      frogsorty.add(frogs.get(i));
    }
    fyit = frogsorty.iterator();
    while (fyit.hasNext()) { 
      Frog f = (Frog)fyit.next();
      float toMove = 0;
      int sign = 1;
      f.vy += s*1;
      if (f.vy < 0)
        sign = -1;
      if (f.vy > s*10)
        f.vy = s*10;
      float lastGood = toMove;
      boolean collided = false;
      int lastColliding = Colliding(f, 0, toMove, time, false);
      int lastPartnerColliding = TILE_NONE;
      if (f.state == STATE_PREP || f.state == STATE_CENS) {
        lastPartnerColliding = Colliding(f.partner, 0, toMove, time, false);
      }
      //println("vy = " + f.vy);
      
      while (sign*toMove < sign*f.vy) {
        int colliding = Colliding(f, 0, toMove, time, false);
        boolean mustStop = (colliding == TILE_WALL || colliding == TILE_FROG || (sign>0 && lastColliding == TILE_NONE && colliding == TILE_CIEL));
        if (!mustStop && (f.state == STATE_PREP || f.state == STATE_CENS)) {
          int partnerColliding = Colliding(f.partner, 0, toMove, time, false);
          mustStop = (partnerColliding == TILE_WALL || partnerColliding == TILE_FROG || (sign>0 && lastPartnerColliding == TILE_NONE && partnerColliding == TILE_CIEL));
          lastPartnerColliding = partnerColliding;
        }
        if (mustStop) {
          //println("collided " + lastColliding + ", " + colliding); //+ ", " + lastPartnerColliding + ", " + partnerColliding);
          collided = true;
          break;
        }
        lastGood = toMove;
        toMove += sign;
        lastColliding = colliding;
      }
      //println("toMove = " + toMove + " ... " + f.vy);
      if (collided)
        f.vy = 0;
      f.y+=lastGood;
      // the below block forces agreement of y between partners; it's kind of arbitrary
      // todo: why is this needed?
      if ((f.state == STATE_PREP || f.state == STATE_CENS) 
        && (f.partner.state == STATE_PREP || f.partner.state == STATE_CENS)
        && f.y != f.partner.y && f.gender == GIRL) // force agreement ...
        f.partner.y = f.y;
    } // (end moving vertically [due to gravity])
    //}
    
    
    // check for frogs stuck in the ceiling; kill them off
    for (int i = 0; i < frogs.size(); i++) {
      Frog f = (Frog)frogs.get(i);
      if ((f.state != STATE_EMERGE || time-f.stateStartTime>5) && Colliding(f, 0, topLeeway, time, true) == TILE_WALL)  // you are stuck in a wall
      {
        if (f.state != STATE_DEAD) {
          if ( (f.state == STATE_PREP || f.state == STATE_CENS) ) { // release partner
            if ( f.partner.state != STATE_DEAD ) {
              f.partner.state = STATE_IDLE;
            }
          }
          f.state = STATE_DEAD;
          f.stateStartTime = time;
        }
      }
      if (f.state == STATE_DEAD)
        f.y -= 2;
    }
    
    // check if anyone has reached the goal
    if (!goalReached) {
      for (int i = 0; i < frogs.size(); i++) {
        Frog f = (Frog)frogs.get(i);
        if (f.state != STATE_DEAD && f.state != STATE_DROWNED && Colliding(f, 0, 10, time, true) == TILE_GOAL) {
          goalReached = true;
          break;
        }
      }
    }
    
    // process mating requests
    for (int i = 0; i < frogs.size()-1; i++) {
      Frog f = (Frog)frogs.get(i);
      if (f.wantsBaby && (f.state == STATE_WALK || f.state == STATE_IDLE)) {
        //println(i + " wants baby");
        for (int j = i + 1; j < frogs.size(); j++) {
          //println(j + " candidate for baby");
          //println("tests: gdiff = " + (g.gender != f.gender)
          //      + " 
          Frog g = (Frog)frogs.get(j);
          float xshift = -9;
          if (f.gender == GIRL)
            xshift = 9;
          if (f.flip)
            xshift = -xshift;
          if ((g.state == STATE_WALK || g.state == STATE_IDLE)
              && g.wantsBaby && g.gender != f.gender && f.y == g.y && f.vy == g.vy && g.pswap == f.pswap
              && g.flip == f.flip && frogFrogOverlap(f, g, xshift, 0, time)) {
            g.stateStartTime = time;
            f.stateStartTime = time;
            f.state = STATE_PREP;
            g.state = STATE_PREP;
            g.partner = f;
            f.partner = g;
          }
        }
      }
    } // (end processing mating)
    
    // clear out dead frogs
    ArrayList frogs2 = new ArrayList();
    for (int i = 0; i < frogs.size(); i++) {
      Frog f = (Frog)frogs.get(i);
      if (!(f.y > height) && !(f.state == STATE_DEAD && fdata.squish[f.gender].isDone(time-f.stateStartTime)))
        frogs2.add(f);
    }
    //println("numfrogs = " + frogs.size());
    frogs = frogs2;
  }

  public void Draw(int time)
  {
    noStroke();
    for (int i = 0; i < tiles.length; i++)
    {
      int x = iToX(i);
      int y = iToY(i);
      int x1 = (int)( x * tile_size_x*s + offx );
      int y1 = (int)( y * tile_size_y*s + offy );
      SetTileColor(x,y,tiles[i]!=TILE_NONE);
      if (tiles[i] == TILE_GOAL) {
        rect(x1,y1,tile_size_x*s,tile_size_y*s);
        fill(255,255,0);
        rect(x1+s*2,y1+s*3,(tile_size_x-4)*s,(tile_size_y-3)*s);
      } else if (tiles[i]==TILE_CIEL) {
        rect(x1,y1,tile_size_x*s,s);
        SetTileColor(x,y,false);
        rect(x1,y1+s,tile_size_x*s,tile_size_y*s-s);
      } else {
        rect(x1,y1,tile_size_x*s,tile_size_y*s);
      }
    }
    for (int i = 0; i < frogs.size(); i++) {
      ((Frog)frogs.get(i)).Draw(time,s);
    }
    if (hasWater) {
      fill(0,0,255,100);
      float wTop = offy+h*tile_size_y*s-waterHeight;
      float wH = waterHeight;
      if (wTop < offy - 4) {
        wTop = offy - 4;
        wH = h*tile_size_y*s+4;
      }
      rect(offx,wTop,w*tile_size_x*s,wH);
    }
  }

  
}




// Displays text using a 3x5 capsfont (how specific!)

class Speech {
  CapsFont f;
  PImage[] frame;
  
   // ugh, we actually need to break this in to corners ...
   // so we can scale horizontally as well as vertically :(
  Speech()
  {
    f = new CapsFont("alphabet_small.gif");
    frame = new PImage[8];
    frame[0] = managedRequestImage("speech_topleft.gif");
    frame[1] = managedRequestImage("speech_topmid.gif");
    frame[2] = managedRequestImage("speech_topright.gif");
    frame[3] = managedRequestImage("speech_midleft.gif");
    frame[4] = managedRequestImage("speech_midright.gif");
    frame[5] = managedRequestImage("speech_botleft.gif");
    frame[6] = managedRequestImage("speech_botmid.gif");
    frame[7] = managedRequestImage("speech_botright.gif");
  }
  
  public void DrawFromBotNoF(float xpos, float ypos, String words, int s, int maxline)
  {
    int numlines = 1 + (words.length()-1) / maxline;
    int len = words.length();
    if (numlines > 1)
      len = maxline;
    if (len < 2)
      len = 2;
    
    boolean flip = true;
    float xoff = (frame[0].width+len*frame[1].width+frame[2].width)*s;
    if (xoff + xpos > 500)
    {
      flip = false;
    }
    DrawFromBotF(xpos, ypos, words, s, maxline, flip);
  }
  
  public void DrawFromBotF(float xpos, float ypos, String words, int s, int maxline, boolean flip)
  {
    int numlines = 1 + (words.length()-1) / maxline;
    int h = frame[0].height*s+(numlines-1)*frame[3].height*s+frame[7].height*s;
    int xoff = 0;
    
    int len = words.length();
    if (numlines > 1)
      len = maxline;
    if (len < 2)
      len = 2;
    
    if (!flip)
    {
      xoff = (len*frame[1].width+2)*s;
    }
    
    Draw(xpos-xoff, ypos-h,words,s,maxline,flip);
  }
  
  public void Draw(float xpos, float ypos, String words, int s, int maxline, boolean flip)
  {
    if (words.length() == 0) {
      words = "  ";
      return;
    }
    if (words.length() == 1)
      words += " ";
    int numlines = 1 + (words.length()-1) / maxline;
    int len = words.length();
    if (numlines > 1)
      len = maxline;
    image(frame[0], xpos, ypos, frame[0].width*s, frame[0].height*s);
    for (int i = 0; i < numlines-1; i++)
    {
//      println("line = " + i + " / " + numlines);
      image(frame[3], xpos, ypos+frame[0].height*s+i*frame[3].height*s, frame[3].width*s, frame[3].height*s);
      image(frame[4], xpos + frame[0].width*s+frame[1].width*s*(len-3),
                    ypos+frame[0].height*s+i*frame[3].height*s, frame[4].width*s, frame[4].height*s);

    }
    
    for (int i = 0; i < len - 3; i++)
    {
      image(frame[1], xpos + frame[0].width*s + frame[1].width*s*i, ypos, frame[1].width*s, frame[1].height*s);
      image(frame[6], xpos + frame[0].width*s + frame[1].width*s*i, 
            ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[6].width*s, frame[6].height*s);
    }
    
    image(frame[2], xpos + frame[0].width*s+frame[1].width*s*(len-3), ypos, frame[2].width*s, frame[2].height*s);
    
    if (flip)
    {
      
      imageFlip(frame[5], xpos + frame[0].width*s+frame[1].width*s*(len-3), 
                    ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[5].width*s, frame[5].height*s);
      imageFlip(frame[7], xpos, ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[7].width*s, frame[7].height*s);
    }
    else
    {
      image(frame[5], xpos, ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[5].width*s, frame[5].height*s);
      image(frame[7], xpos + frame[0].width*s+frame[1].width*s*(len-3), 
                    ypos+frame[0].height*s+(numlines-1)*frame[3].height*s, frame[7].width*s, frame[7].height*s);
    }
    
    fill(192);
    stroke(192);
    rect(xpos+frame[0].width*s, ypos+frame[0].height*s, (len-3)*frame[1].width*s, 
            (numlines-1)*frame[3].height*s);
            
    for (int i = 0; i < numlines; i++)
    {
//      println(i*maxline + ", " + max((i+1)*maxline,len));
      f.DrawString(xpos + 5*s, ypos+7*s*i+4*s, words.substring(i*maxline,min((i+1)*maxline,words.length())), s);
    }
  }
  
}

public void imageFlip(PImage i, float xpos, float ypos, float w, float h)
{
  pushMatrix();
  scale(-1,1);
  image(i, -xpos, ypos, -w, h);
  popMatrix();
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#F0F0F0", "frogsport" });
  }
}
