
//import javax.media.opengl.*;
//import processing.opengl.*;

int KEY_LEFT = 0;
int KEY_RIGHT = 1;
int KEY_UP = 2;
int KEY_DOWN = 3;
int KEY_RET = 4;
int KEY_BACKSPACE = 5;
int KEY_SPACE = 6;
int KEY_Z = 7;
int KEY_R = 8;
int KEY_MAX = 9;

int GAME_INTRO = 0;
int GAME_PLAY = 1;
int GAME_BETWEEN = 3;
int GAME_END = 2;


int time;
int gameState = GAME_INTRO;
int stageMenu = -1;

boolean keysDown[];

CapsFont words;

int worldScale = 2;

Dude duder;
Level lev;

boolean rectOverlap(float ax1, float ay1, float ax2, float ay2,
                    float bx1, float by1, float bx2, float by2) {
  return !(ax2 < bx1 || ax1 > bx2 || ay2 < by1 || ay1 > by2);
}

void display(PImage im, int xpos, int ypos, int scaling, boolean flip) {
  int fs = 1;
  if (flip) {
    pushMatrix();
    scale(-1,1);
    fs = -1;
  }
  image(im, fs*xpos, ypos, fs*im.width*scaling,im.height*scaling);
  if (flip)
    popMatrix();
}

ArrayList images = new ArrayList();
PImage managedRequestImage(String file)
{
  PImage req = requestImage(file);
  images.add(req);
  return req;
}

int requestsSatisfied()
{
  int sat = 0;
  for (int i = 0; i < images.size(); i++)
  {
    PImage img = (PImage)images.get(i);
    if (img.width != 0)
      sat++;
  }
  return sat;
}

float s_offx = 80, s_offy = 70;
int s_tile_size_y = 16, s_tile_size_x = 12, s_s = 2;
String levels[] = {"lev0.txt", "lev1.txt", "lev4.txt",
                  "lev6.txt", "lev3.txt", "lev5.txt","lev9.txt",
                  "lev7.txt", "lev2.txt", "lev8.txt"
                  };
String levelNames[] = /*{"starting out easy", "visible stairs", "make room", 
                      "invisible stairs", "above and below", "a shallow pit", 
                      "frogs cant multitask"}*/
                      {"frogs walk right", "frogs cant jump", "frogs make room", 
                      "frogs cant multitask", "above and below", "a shallow pit","race to the top",
                      "frogs cant swim", "love trumps all", "teamwork"
                      };
boolean completed[];
int curLevel = 0;

PImage realfrog;

void setup() {
  size(800, 600);
  frameRate(50);
  noSmooth();
  //GL gl = g.beginPGL().gl;
  //gl.glTexParameterf(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST);
  //gl.glTexParameterf(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST);
  //g.endPGL();
  keysDown = new boolean[KEY_MAX];
  for (int i = 0; i < KEY_MAX; i++)
  {
    keysDown[i] = false;
  }
  
  words = new CapsFont("alphabet.gif");
  //duder = new Dude(200,200);
  fdata = new FrogData();
  
  completed = new boolean[levels.length];
  for (int i = 0; i <completed.length; i++) {
    completed[i] = false;
  }
  
  realfrog = managedRequestImage("frogreal.gif");
  
}

boolean slowMode = false;
boolean retPressedLast = false;
boolean spacePressedLast = false;
boolean zPressedLast = false;
boolean arrowsPressedLast = false;
boolean readyToAdvance = false;

void draw() {
  
  int reqsat = requestsSatisfied();
  if (reqsat < images.size())
  {
    background(0,128,0);
    fill(200,10,10);
    stroke(100,30,30);
    rect(50,200,425 * reqsat / images.size(),20);
    return;
  }
  
  if (gameState == GAME_INTRO) {
    time++;
    background(200,200,0);
    fill(50,100,50);
    if (stageMenu == -1) {
      words.DrawString(30,20,"endless frog kids", 7);
      words.DrawString(150,110,"press z to start", 5);
      for (int i = 0; i < 20; i++) {
        for (int j = 0; j < 7; j ++) {
          fdata.idle[(i+j)%2].display(-2+40*i,150+70*j,time,true,4,true);
        }
      }
    } else {
      background(100,150,50);
      fill(50,100,150);
      stroke(100,30,30);
      words.DrawString(20,20,"select level",10);
      for (int i = 0; i < levels.length; i++) {
        if (i == curLevel) {
          fdata.walk[1].display(20,100+i*7*6,time,true,2,true);
          fill(50,100,150);
          stroke(100,30,30);
          rect(50,100+i*7*6,levelNames[i].length()*5*6,6*6);
          if (completed[i]) {
            words.DrawString(55+levelNames[i].length()*5*6, 100+i*7*6+15,"completed",2);
          }
        } else if (completed[i]) {
          fill(150,150,150);
          stroke(100,100,100);
          rect(50,100+i*7*6,levelNames[i].length()*5*6,6*6);
        }
        words.DrawString(50+3,100+i*7*6+3,levelNames[i],5);
      }
      if ((keysDown[KEY_RIGHT] || keysDown[KEY_DOWN]) && !arrowsPressedLast) {
        curLevel = (curLevel+1)%levels.length;
      }
      if ((keysDown[KEY_LEFT] || keysDown[KEY_UP]) && !arrowsPressedLast) {
        curLevel = (curLevel+levels.length-1)%levels.length;
      }
      arrowsPressedLast = keysDown[KEY_LEFT] || keysDown[KEY_RIGHT] || keysDown[KEY_UP] || keysDown[KEY_DOWN];
    }
    if (keysDown[KEY_Z] && !zPressedLast) {
      if (stageMenu == -1)
        stageMenu = 0;
      
    } else if (readyToAdvance && !keysDown[KEY_Z] && zPressedLast) {
      lev = new Level(levels[curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
      gameState = GAME_PLAY;
      readyToAdvance = false;
    }
    if (stageMenu > -1 && !keysDown[KEY_Z] && !zPressedLast)
      readyToAdvance = true;
    zPressedLast = keysDown[KEY_Z];
    
    return;
  }
  
  if (gameState == GAME_PLAY)
  {
    background(200,200,200);
    fill(50,100,50);
    /*
    if (keysDown[KEY_SPACE] && !spacePressedLast) {
      println("slow mode toggled!");
      slowMode = !slowMode;
    }
    spacePressedLast = keysDown[KEY_SPACE];
    */
    
    if (keysDown[KEY_BACKSPACE])
      gameState = GAME_BETWEEN;
    
    words.DrawString(width / 2 - (levelNames[curLevel].length()*6*5/2), 20, levelNames[curLevel], 5);
    words.DrawString(220,s_offy+s_tile_size_y*s_s*lev.h+100+20,"to play press z and arrows", worldScale);
    words.DrawString(250,s_offy+s_tile_size_y*s_s*lev.h+100+35,"press r to reset level", worldScale);
    words.DrawString(180,s_offy+s_tile_size_y*s_s*lev.h+100+50,"press q to return to level select", worldScale);
    
    words.DrawString(200,s_offy+s_tile_size_y*s_s*lev.h+45,"now producing", 4);
    fdata.idle[lev.activeGender].display(535,s_offy+s_tile_size_y*s_s*lev.h+20,time,true,4,true);
    
    if (keysDown[KEY_R]) {
      lev = new Level(levels[curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
    }
    
    //duder.Draw(time,2);
    if (!slowMode || (keysDown[KEY_RET] && !retPressedLast) || keysDown[KEY_BACKSPACE])
      lev.Update(time);
    lev.Draw(time);
    
    if (lev.goalReached) {
      completed[curLevel] = true;
      boolean allDone = true;
      for (int i = 0; i < completed.length; i++) {
        if (!completed[i]) // if something's not completed go back to men
          allDone = false;
      }
      println("reached goal!");
      if (allDone) {
        gameState = GAME_END;
      }
      else if (curLevel+1 < levels.length) {
        lev = new Level(levels[++curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
        gameState = GAME_BETWEEN;
        zPressedLast = keysDown[KEY_Z];
      } else {
        gameState = GAME_INTRO;
      }
    }
    
    if (!slowMode || (keysDown[KEY_RET] && !retPressedLast) || keysDown[KEY_BACKSPACE])
      time++;
    retPressedLast = keysDown[KEY_RET];
    return;
  } else if (gameState == GAME_END) {
    background(200,200,200);
    fill(50,100,50);
    words.DrawString(50,20,"you win hooray", 5);
    words.DrawString(100,100,"more levels coming soon probably", 1);
    float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "you have won the game", 2);
      words.DrawString(100, ystart+65, "or at least what is done so far", 2);
      words.DrawString(100, ystart+85, "thanks for playing", 2);
      words.DrawString(100, ystart+100,"you heartless global machine", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+110,440,ymid+60);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "h", 3);
      //words.Draw(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "s", 3);
      //words.Draw(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure ten", 2);
      words.DrawString(210, ymid+185, "i have not yet made up a figure", 2);
      words.DrawString(210, ymid+200, "for the last level of the game", 2);
    return;
  } else if (gameState == GAME_BETWEEN) {
    background(50,100,150);
    fill(50,100,50);
    if (keysDown[KEY_Z] && !zPressedLast) {
      gameState = GAME_PLAY;
    }
    zPressedLast = keysDown[KEY_Z];
    words.DrawString(80,50,"level complete", 8);
    words.DrawString(100,110,"for next level press z", 3);
    if (curLevel == 1) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "globalization has quickly replaced traditional", 2);
      words.DrawString(100, ystart+65, "frog culture with a more modern human lifestyle", 2);
      words.DrawString(100, ystart+85, "frogs have abandoned their wild hoppy ways and", 2);
      words.DrawString(100, ystart+100, "now they march in unison with the global machine", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      fdata.idle[0].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(250, ymid+130, "before", 3);
      words.DrawString(400, ymid+130, "after", 3);
      words.DrawString(230, ymid+170, "figure one", 2);
      words.DrawString(230, ymid+185, "effects of globalization", 2);
      words.DrawString(230, ymid+200, "on frog culture", 2);
    } else if (curLevel == 2) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "globalization has pressured female frogs to", 2);
      words.DrawString(100, ystart+65, "submit to the fickle whims of human fashion", 2);
      words.DrawString(100, ystart+85, "they dont know their lipstick was tested on ", 2);
      words.DrawString(100, ystart+100, "captive lab frogs", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(250, ymid+130, "before", 3);
      words.DrawString(400, ymid+130, "after", 3);
      words.DrawString(230, ymid+170, "figure two", 2);
      words.DrawString(230, ymid+185, "effects of globalization", 2);
      words.DrawString(230, ymid+200, "on female frog fashions", 2);
    } else if (curLevel == 3) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-88*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "a sampling of cogs in the global machine confirms", 2);
      words.DrawString(100, ystart+65, "the global machine is heartless", 2);
      words.DrawString(100, ystart+85, "a statistically significant percentage do not worry", 2);
      words.DrawString(100, ystart+100,"when frogs are squished for the greater good", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(400,ymid+110,40,10);
      rect(290,ymid+50,40,70);
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(395, ymid+133, "yes", 3);
      words.DrawString(293, ymid+133, "no", 3);
      words.DrawString(210, ymid+170, "figure three", 2);
      words.DrawString(210, ymid+185, "response to poll question", 2);
      words.DrawString(210, ymid+205, "are you not heartless?", 2);
    } else if (curLevel == 4) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "the mating song is the one refuge of frogs from", 2);
      words.DrawString(100, ystart+65, "the unending demands of the global machine", 2);
      words.DrawString(100, ystart+85, "unfortunately the global machine has learned", 2);
      words.DrawString(100, ystart+100,"to reproduce this mating song artificially", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(400,ymid+110,40,10);
      rect(290,ymid+50,40,70);
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(395, ymid+133, "sex", 3);
      words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure four", 2);
      words.DrawString(210, ymid+200, "frog responsiveness", 2);
      words.DrawString(210, ymid+185, "effects of mating on", 2);
    } else if (curLevel == 5) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "the societal status of a male frog is equal", 2);
      words.DrawString(100, ystart+65, "to the height from which it was born", 2);
      words.DrawString(100, ystart+85, "the only use of a male frog beneath you", 2);
      words.DrawString(100, ystart+100,"is to step on its head", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+110,440,ymid+60);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "h", 3);
      //words.DrawString(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "s", 3);
      //words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure five", 2);
      words.DrawString(210, ymid+185, "male frog social status s versus", 2);
      words.DrawString(210, ymid+200, "initial height h in level", 2);
    } else if (curLevel == 6) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "the endless fertility of frogs is great", 2);
      words.DrawString(100, ystart+65, "for filling pot holes", 2);
      words.DrawString(100, ystart+85, "to the global machine frogs may as well be", 2);
      words.DrawString(100, ystart+100,"some new form of pavement", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(400,ymid+110,40,10);
      rect(275,ymid+50,40,70);
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(365, ymid+133, "asphalt", 3);
      words.DrawString(250, ymid+133, "frogs", 3);
      words.DrawString(210, ymid+170, "figure six", 2);
      words.DrawString(210, ymid+185, "cost effectiveness of frogs", 2);
      words.DrawString(210, ymid+200, "compared to asphalt", 2);
    } else if (curLevel == 7) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "at current exponential growth rates frogs", 2);
      words.DrawString(100, ystart+65, "will soon be the majority species on earth ", 2);
      words.DrawString(100, ystart+85, "shortly thereafter they will outnumber", 2);
      words.DrawString(100, ystart+100, "the atoms in the universe", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+60,302,ymid+110);
      line(302,ymid+110,450,ymid+110);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "s", 3);
      //words.DrawString(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "t", 3);
      //words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure eight", 2);
      words.DrawString(210, ymid+185, "space in universe not occupied by frogs s", 2);
      words.DrawString(210, ymid+200, "plotted against time t", 2);
    } else if (curLevel == 8) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+50, "before globalization frogs had a rich swimming", 2);
      words.DrawString(100, ystart+65, "tradition and were some of the worlds ", 2);
      words.DrawString(100, ystart+80, "best known amphibians", 2);
      words.DrawString(100, ystart+100, "now they can hardly hold their breath", 2);
      words.DrawString(100, ystart+115,"for even a few seconds underwater", 2);
      
      fill(200,200,0);
      stroke(0,0,0);
      rect(242,ymid+40,250,120);
      fill(230,230,230);
      stroke(0,0,0);
      rect(285,ymid+50, 180, 70); 
      line(300,ymid+60,440,ymid+110);
      //rect(400,ymid+110,40,10);
      //rect(290,ymid+50,40,70);*/
      //image(realfrog, 260,ymid+50,realfrog.width*5, realfrog.height*5);
      //fdata.idle[1].display( 410, ymid+40, 0, false, 5, false);
      words.DrawString(260, ymid+60, "s", 3);
      //words.DrawString(275, ymid+126, "o", 3);
      words.DrawString(445, ymid+130, "g", 3);
      //words.DrawString(255, ymid+133, "no sex", 3);
      words.DrawString(210, ymid+170, "figure eight", 2);
      words.DrawString(210, ymid+185, "frog swimming ability s with respect to", 2);
      words.DrawString(210, ymid+200, "level of globalization g", 2);
    } else if (curLevel == 9) {
      float ystart = 170;
      float ymid = ystart + 100;
      fill(70,150,70);
      stroke(200,100,0);
      rect(90,ystart,width-90*2,height-ystart-100);
      words.DrawString(200, ystart+10, "did you know?", 5);
      words.DrawString(100, ystart+65, "frogs are an excellent new organic material", 2);
      words.DrawString(100, ystart+80, "for building bridges ", 2);
      float ww = frogW*3/2-5;
      float hh = frogH*3/2-1;
      float xbase = 280;
      fill(200,200,0);
      stroke(0,0,0);
      rect(245,ymid+10,190,155);
      fdata.idle[0].display( xbase, ymid+110, 0, false, 3, true);
      fdata.idle[1].display( xbase+ww, ymid+110-hh, 0, false, 3, true);
      fdata.idle[0].display( xbase+2*ww, ymid+110-hh*2, 0, false, 3, true);
      fdata.idle[1].display( xbase+3*ww, ymid+110-hh, 0, false, 3, false);
      fdata.idle[0].display( xbase+4*ww, ymid+110, 0, false, 3, false);
      words.DrawString(210, ymid+173, "figure nine", 2);
      words.DrawString(210, ymid+188, "spiky bridge is made of frogs", 2);
      
    }
    return;
  }
  
  // the basic layout 
  background(128,0,0);
  fill(0);
  stroke(0);
  //rect(11,11,frame.width*3-2, frame.height*3-2);

  time++;
}


boolean failedPress = false;


void keyPressed()
{
  // todo, remove level skip hack
  int keynum = key - '0';
  if (keynum >= 0 && keynum <= 6) {
    curLevel = keynum;
    lev = new Level(levels[curLevel], s_offx, s_offy, s_tile_size_x, s_tile_size_y, s_s, time);
  }
  
  if (key == ESC) { // map esc to 'q' to avoid the automatic handling (which quits the program, nonsense for applets ...)
    key = 'q';
  }
  
  if (key == 'q' || key == 'Q') {
    gameState = GAME_INTRO;
  }
  
  if (key == RETURN || key == ENTER)
    keysDown[KEY_RET] = true;
  if (key == BACKSPACE)
    keysDown[KEY_BACKSPACE] = true;
  if (key == ' ')
    keysDown[KEY_SPACE] = true;
  if (key == 'Z' || key == 'z')
    keysDown[KEY_Z] = true;
  if (key == 'R' || key == 'r')
    keysDown[KEY_R] = true;
  
  if (key == CODED) // coded keys are just character movement
  {
    if (keyCode == LEFT)
      keysDown[KEY_LEFT] = true;
    if (keyCode == RIGHT)
      keysDown[KEY_RIGHT] = true;
    if (keyCode == UP)
      keysDown[KEY_UP] = true;
    if (keyCode == DOWN)
      keysDown[KEY_DOWN] = true;
  }

}

void keyReleased()
{
  if (key == RETURN || key == ENTER)
    keysDown[KEY_RET] = false;
  if (key == BACKSPACE)
    keysDown[KEY_BACKSPACE] = false;
  if (key == ' ')
    keysDown[KEY_SPACE] = false;
  if (key == 'Z' || key == 'z')
    keysDown[KEY_Z] = false;
  if (key == 'R' || key == 'r')
    keysDown[KEY_R] = false;
    
  if (key == CODED) // coded keys are just character movement
  {
    if (keyCode == LEFT)
      keysDown[KEY_LEFT] = false;
    if (keyCode == RIGHT)
      keysDown[KEY_RIGHT] = false;
    if (keyCode == UP)
      keysDown[KEY_UP] = false;
    if (keyCode == DOWN)
      keysDown[KEY_DOWN] = false;
  }
  
}

